/* $Id: csp_defs.h,v 1.11 2004/02/07 11:03:00 root Exp $ */

#ifndef CSP_DEFS_INCLUDED
#define CSP_DEFS_INCLUDED

#define BUILD_DOS 1
#define BUILD_OS2 2
#define BUILD_WIN 3

#if BUILDMODE==BUILD_DOS
 #define PROD_OS            "DOS-16"
#elif BUILDMODE==BUILD_OS2
 #if !defined(__32BIT__)&&!defined(__HIGHC__)&&!defined(M_I386)
  #define PROD_OS          "OS/2-16"
 #else
  #define PROD_OS          "OS/2-32"
 #endif
#elif BUILDMODE==BUILD_WIN
 #define PROD_OS             "Win16"
#elif defined(linux)
 #define PROD_OS             "Linux"
#elif defined(__FreeBSD__)
 #define PROD_OS           "FreeBSD"
#else
 #define PROD_OS           "generic"
#endif

/* Microsoft */
#ifdef _MSC_VER
 #if _MSC_VER==510
  #define PROD_COMPILER   "Microsoft C v 5.10"
 #elif _MSC_VER==600
  #define PROD_COMPILER   "Microsoft C v 6.00"
 #elif _MSC_VER==700
  #define PROD_COMPILER   "Microsoft C++ v 7.00"
 #elif _MSC_VER==800
  #define PROD_COMPILER   "Microsoft Visual C++"
 #else
  #define PROD_COMPILER   "Microsoft C/C++"
 #endif
#endif
/* IBM */
#ifdef __IBMC__
 #define IBMCPP __IBMC__
#endif
#ifdef __IBMCPP__
 #define IBMCPP __IBMCPP__
#endif
#ifdef IBMCPP
 #if IBMCPP>430
  #define PROD_COMPILER  "VisualAge C++ v4.0"
 #elif IBMCPP==430
  #define PROD_COMPILER  "VisualAge C++ v3.6"
 #elif IBMCPP>=300
  #define PROD_COMPILER  "VisualAge C++ v3.0"
 #else
  #define PROD_COMPILER  "IBM C Set++ v 2.01"
 #endif
 #undef IBMCPP
#endif
/* MetaWare */
#ifdef __HIGHC__
 #define PROD_COMPILER   "MetaWare High C/C++"
#endif
/* Borland C */
#if defined(__BORLANDC__)
 #define PROD_COMPILER   "Borland C++"
#elif defined(__TURBOC__)
 #define PROD_COMPILER   "Turbo C++"
#endif
/* Watcom */
#if defined(__WATCOMC__)
 #if __WATCOMC__>=1100
  #define PROD_COMPILER  "OpenWatcom C v 11.0"
 #elif __WATCOMC__>=1000
  #define PROD_COMPILER  "Watcom C/C++ v 10.0"
 #else
  #define PROD_COMPILER  "Watcom C"
 #endif
#endif
/* GCC/EMX */
#ifdef __EMX__
 #define PROD_COMPILER   "GNU C++ for OS/2"
#endif
/* Linux - assume GCC */
#ifdef linux
 #define PROD_COMPILER   "GNU C/C++ on Linux"
#endif

#ifdef PROD_COMPILER
 #ifdef LIBC
  #define PROD_STRING     PROD_OS "; " PROD_COMPILER "; libc"
 #else
  #define PROD_STRING     PROD_OS "; " PROD_COMPILER
 #endif
#else
 #define PROD_STRING     PROD_OS
#endif

/* Linux hacking */

#if !defined(HAVE_MAX)&&!defined(max)&&!defined(_MSC_VER)
 #define max(a, b) ((a)>(b)?(a):(b))
#endif

#endif
