/* REXX: Set basic file type */

Call RxFuncAdd SysLoadFuncs, RexxUtil, SysLoadFuncs
Call SysLoadFuncs

Call SetType   "descript.ion"           "Plain Text"
Call SetType   "file_id.deu"            "Plain Text"
Call SetType   "file_id.eng"            "Plain Text"
Call SetType   "md5_sum.asc"            "PGP"

Call SetType   "bin\descript.ion"       "Plain Text"
Call SetType   "bin\os2boot_.ac"        "Binary Data"
Call SetType   "bin\os2krnd.ac"         "Binary Data"

Call SetType   "bin\de\descript.ion"    "Plain Text"
Call SetType   "bin\de\os2csmm.bin"     "Binary Data"
Call SetType   "bin\de\os2csmr.bin"     "Binary Data"

Call SetType   "bin\en\descript.ion"    "Plain Text"
Call SetType   "bin\en\os2csmm.bin"     "Binary Data"
Call SetType   "bin\en\os2csmr.bin"     "Binary Data"

Call SetType   "bin\fr\descript.ion"    "Plain Text"
Call SetType   "bin\fr\os2csmm.bin"     "Binary Data"
Call SetType   "bin\fr\os2csmr.bin"     "Binary Data"

Call SetType   "bin\it\descript.ion"    "Plain Text"
Call SetType   "bin\it\os2csmm.bin"     "Binary Data"
Call SetType   "bin\it\os2csmr.bin"     "Binary Data"

Call SetType   "bin\jp\descript.ion"    "Plain Text"
Call SetType   "bin\jp\os2csmm.bin"     "Binary Data"
Call SetType   "bin\jp\os2csmr.bin"     "Binary Data"

Call SetType   "bin\nl\descript.ion"    "Plain Text"
Call SetType   "bin\nl\os2csmm.bin"     "Binary Data"
Call SetType   "bin\nl\os2csmr.bin"     "Binary Data"

Call SetType   "bin\ru\descript.ion"    "Plain Text"
Call SetType   "bin\ru\os2csmm.bin"     "Binary Data"
Call SetType   "bin\ru\os2csmr.bin"     "Binary Data"

Call SetType   "bin\sp\descript.ion"    "Plain Text"
Call SetType   "bin\sp\os2csmm.bin"     "Binary Data"
Call SetType   "bin\sp\os2csmr.bin"     "Binary Data"

Call SetType   "doc\descript.ion"       "Plain Text"
Call SetType   "doc\autor.txt"          "Plain Text"
Call SetType   "doc\os2csm.deu"         "Plain Text"
Call SetType   "doc\os2csm.eng"         "Plain Text"
Call SetType   "doc\os2csm.esp"         "Plain Text"
Call SetType   "doc\os2csm.fra"         "Plain Text"
Call SetType   "doc\os2csm.png"         "picture"
Call SetType   "doc\programm.deu"       "Plain Text"
Call SetType   "doc\programm.eng"       "Plain Text"

Call SetType   "example\descript.ion"   "Plain Text"
Call SetType   "example\blank.bin"      "Binary Data"
Call SetType   "example\cancel.bin"     "Binary Data"
Call SetType   "example\confirm.bin"    "Binary Data"
Call SetType   "example\confi__.sys"    "Plain Text"
Call SetType   "example\menu.bin"       "Binary Data"
Call SetType   "example\menu.txt"       "Plain Text"
Call SetType   "example\menu5net.bin"   "Binary Data"
Call SetType   "example\menu_nic.txt"   "Plain Text"
Call SetType   "example\nic.lst"        "Plain Text"
Call SetType   "example\reset.bin"      "Binary Data"

Call SetType   "exe\descript.ion"       "Plain Text"
Call SetType   "exe\ac.exe"             "Executable"
Call SetType   "exe\align512.exe"       "Executable"
Call SetType   "exe\aligncsm.cmd"       "OS/2 Command File"
Call SetType   "exe\checkcsm.exe"       "Executable"
Call SetType   "exe\gennmenu.exe"       "Executable"
Call SetType   "exe\os2csm.com"         "Executable"
Call SetType   "exe\os2csm.exe"         "Executable"
Call SetType   "exe\stripcsm.cmd"       "OS/2 Command File"
Call SetType   "exe\wdosxle.exe"        "Executable"

Call SetSubject ""
Call SetSubject "bin\"
Call SetSubject "doc\"
Call SetSubject "example\"
Call SetSubject "exe\"

Call LineOut , "."
Exit 0


SetSubject:
  Parse Arg Verzeichnis
  di=Verzeichnis"descript.ion"
  rc=Stream(di, 'C', 'Open')
  do while Lines(di)
    l=LineIn(di)    
    Parse Var l fn " " dsc
    t1 = "FDFF"x || d2c(Length(dsc)) || '00'x || dsc
    Call SysPutEA Verzeichnis||fn , ".SUBJECT" , t1
    Call CharOut , "."
  end
  rc=Stream(di, 'C', 'Close')
  Return 0


SetType:
  Call CharOut , "."
  Parse Arg Dateiname Dateityp
  /* ASCII */
  t1 = "FDFF"x || d2c(Length(Dateityp)) || '00'x || Dateityp
  /* mehrtypig/mehrwertig, 1 Element */
  t2 = "DFFF0000"x || "0100"x || t1
  Call SysPutEA Dateiname , ".TYPE" , t2
  Return 0

