/* REXX: markup config.sys aligned to 512 bytes */

        /* read input */
        Parse Arg name
        j = 0
        do while lines(name)
          ibuf = linein(name)
          jbuf = translate(ibuf)
          if (pos("REM V.K. * OS2CFG *",jbuf)>0) then iterate
          if (pos("REM 512CONF",jbuf)>0) then iterate
          j = j + 1
          lines.j = ibuf

          if 512<Length("REM V.K. * OS2CFG * 0000")+2 + Length(ibuf)+2 + Length("REM 512CONF+")+2 then
            do
              Say "line "||j||" is to long."
              Say lines.j
              Return 99
            end
        end

        /* write output */
        if (j>0) then do

          Call lineout name
          '@Call del 'name

          page = 0
          pagepos = 0

          lines.0 = j
          do i = 1 to lines.0

            /* enough space left ? */
            if pagepos + Length(lines.i) + 2 + Length("REM 512CONF+") +2 > 512 then
              do /* no, fill page */
                Call My_LineOut "REM 512CONF"||Copies("*",512-1-2-Length("REM 512CONF")-pagepos)||"+"
                pagepos = 0
                page = page + 1
              end

            /* mark new page ? */
            if pagepos = 0 then
              Call My_LineOut "REM V.K. * OS2CFG * "||Right(page,4,"0")

            /* put a line */
            Call My_LineOut lines.i

          end

          /* fill to end of file */
          Call My_LineOut "REM 512CONF"||Copies("*",512-1-2-Length("REM 512CONF")-pagepos)||"-"
          Call My_LineOut ""
        end
        Return

My_LineOut:     Procedure       Expose name pagepos

        Parse Arg configsys_line
        Call LineOut name, configsys_line
        pagepos = pagepos + Length(configsys_line) + 2
        Return

