/*
 View and manipulate OS/2 multimedia codecs
 (c)1997 Roman Trunov, 2:5022/2
 */

signal on novalue

Call RxFuncAdd "SysLoadFuncs", "RexxUtil", "SysLoadFuncs"
Call SysLoadFuncs

app = "MMIOINIT"
ininame = "MMPMMMIO.INI"
pos = 1
numeric digits 10

parse upper arg command val

select
	when command="L" then call ListCodecs
	when command="V" then call ViewCodecs
	when command="D" then call DeleteCodecs
	otherwise call Usage
end
exit

CodecUsage:
	say "Error! Codec ID must be a number from 1 to max_codec_count!"
	say "       Use 'L' or 'V' commands to see codec IDs"
	say

Usage:
	say "Usage: CODECS command [codec#]"
	say "   L       - list codecs in short form"
	say "   V       - view detailed codecs description"
	say "   D ##    - delete codec number ##"
	say "             (don't forget do backup" ininame "before this)"
	exit

ViewCodecs:
	call Startup
	call LoadInfo
	do i=1 to codecs
		say center(" Processing codec" i "of" codecs " ", 50, "-")
		call DisplayOneCodec
	end
return

ListCodecs:
	call Startup
	say "Codec # | DLL Name | Format ID / Compression | Output"
	say "--------+----------+-------------------------+--------"
	do i=1 to codecs
		call FillCodecData
		say left(i, 7) "|" left(cdata.3,8) "|" left(cdata.2 "-" cdata.5 "-" cdata.6, 23) "|" left(cdata.13, 5)
	end
return

DeleteCodecs:
	call Startup
	call LoadInfo
	if \datatype(val, 'WHOLE') then
		call CodecUsage
	pos = (val-1)*404+1
	if val = 0 | pos >= length(data) then
		call CodecUsage
	call DisplayOneCodec
	say
	if cdata.1 \= 404 then do
		say 'Error! This codec has unsupported structure length or was created with'
		say '       another version of MMPM. For safety, it cannot be deleted.'
		exit 1
	end
	call CharOut , "Do you really want to DELETE this codec (Y/N) ? "
	if askYesNo() then do
		say 'Deleting codec and updating .INI-files...'
		pos = (val-1)*404+1
		data = delstr(data, pos, 404)
		codecs = codecs-1
		call UpdateINI
		say 'All went OK'
	end
	else
		say 'Operation cancelled. No changes made.'
return

askYesNo:
	do forever
		c = translate(SysGetKey("NOECHO"))
		if c = 'Y' then do
			say 'Yes'
			return 1
		end
		if c = 'N' then
			say "No"
			return 0
		end
	end

FillCodecData:
	cdata.1  = getnum()
	cdata.2  = getstr(4)
	cdata.3  = getstrip(260)
	cdata.4  = getstrip(32)
	cdata.5  = getspecialnum()
	cdata.6  = getnum()
	cdata.7  = getnum()
	cdata.8  = gethex()
	cdata.9  = getnum()
	cdata.10 = getstrip(32)
	cdata.11 = getnum()
	cdata.12 = getnum()
	cdata.13 = getstrip(4)
	cdata.14 = getnum()
	cdata.15 = getnum()
	cdata.16 = getstrip(32)
return

LoadInfo:
	info.0  = 16
	info.1  = 'Structure length'
	info.2  = 'File format ID'
	info.3  = 'DLL name string'
	info.4  = 'Procedure name string'
	info.5  = 'Compression type'
	info.6  = 'Compression subtype'
	info.7  = 'Media type'
	info.8  = 'Capability flags'
	info.9  = 'Flags'
	info.10 = 'Specific information'
	info.11 = 'Max. source buffer leghth'
	info.12 = 'Synchronization method'
	info.13 = 'Preferred output format'
	info.14 = 'X aligment'
	info.15 = 'Y aligment'
	info.16 = 'Specific codec info'
return

DisplayOneCodec:
	call FillCodecData
	do k=1 to info.0
		say left(info.k, 26) ":" cdata.k
	end
return
	
Startup:
	ini = SysSearchPath("MMBASE", ininame)
	if ini \= "" & stream(ini, "C", "QUERY EXISTS") \= "" then do
		codecs = SysIni(ini, app, "CODECCOUNT")
		if codecs \= "ERROR:" then do
			codecs = decimal(codecs)
			data = SysIni(ini, app, "CODECMODINFO")
			if data \= "ERROR:" then
				return
		end
	end
	say "Error! Cannot get information from" ini || "!"
	say "Make sure you running this program from \MMOS2 directory"
	say "or MMBASE enviroment variable is set"
	exit 1

UpdateIni:
	codecs = reverse(d2c(codecs, 2))
	if SysIni(ini, app, "CODECCOUNT", codecs) \= '' | SysIni(ini, app, "CODECMODINFO", data) \= '' then do
		say 'A FATAL ERROR was occured during update of' ini
		say '              I hope you have a backup copy.'
		exit 1
	end
	return

GetNum:
	x = decimal(substr(data, pos, 4))
	pos = pos + 4
return x

GetStr:
	arg _len
	x = substr(data, pos, _len)
	pos = pos + _len
return x

GetStrip:
	arg _len
	x = getstr(_len)
return strip(translate(x, '20'x, '00'x))

GetHex:
return d2x(getnum()) || 'h'

Decimal:
	arg c
return c2d(reverse(c))

GetSpecialNum:
	x = substr(data, pos, 4)
	pos = pos+4
	if right(x, 2) = '0000'x then
		return '#' || decimal(x)
return strip(translate(x, '20'x, '00'x))

novalue:
	say "! ERROR ! Undefined variable referenced on line" sigl 
	exit 1
