/*** ThirdEye REXX Interface API Usage Example      ***/
/*** (c) 2001-2003 Andrei A. Porodko                ***/
/***          Fixed by tam, 10 april, 2002          ***/

/*** Function Return Code Definitions ************/
RET_OK               =  0
RET_NOT_ENOUGH_MEM   = -1
RET_INSUFF_PARAMS    = -2
RET_NOT_CONNECTED    = -3
RET_NOT_LOADED       = -4
RET_CANT_GET_PICTURE = -5
RET_CANT_DEL_PICTURE = -6
RET_CANT_GET_NUMBER  = -7
RET_CANT_GET_CAMNAME = -8
RET_CANT_TAKE_PIC    = -9


SAY 'ThirdEye REXX Interface v1.0. Usage Example'
SAY '(c) 2001-2003 Andrei A. Porodko, eCo Software'
SAY
SAY 'Registering all Functions for further usage'
SAY

CALL RxFuncAdd 'camxInit', '3eyeRexx', 'camxInit'
CALL camxInit
SAY  camxGetVersion()

port = 'COM1'
baud = 57600
camera = 'OLYMPUS'
SAY 'Connecting to ' camera' attached to' port '... on' baud

rc = camxConnect(port,baud,camera)
IF  rc \== RET_OK THEN DO
    SAY 'Err: Connection to Camera Failure, code =' rc
    SAY '     Check the Connection or Parameters.'
    CALL camxQuit
    EXIT
END
SAY 'Ok'
SAY
SAY 'Getting Various Information from Camera'
SAY
SAY 'Camera full name = ' camxGetCameraName()
SAY 'Frames taken     = ' camxFramesTaken()
SAY 'Frames left      = ' camxFramesLeft()
SAY
DO i = 1 BY 1 WHILE i < camxFramesTaken() + 1
    name = 'dsc_'i'.jpg'
    SAY 'Downloading picture number' i name
    SAY 'Result of downloading' camxGetPicture(i,name,0)
END

CALL camxDisconnect
CALL camxQuit
EXIT

/*
    End of Example
*/
