#define INCL_DOSDEVICES
#define INCL_DOSDEVIOCTL
#define INCL_DOSFILEMGR
#define INCL_DOSERRORS
#define INCL_DOSMISC
#include <os2.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>
#include <time.h>

#include "Defines.h"
#include "Structures.h"
#include "SupportFunctions.h"
#include "DisplayFunctions.h"
#include "DiskFunctions.h"

int main(int argc, char *argv[])
{
    UCHAR driveString[3], dfName[256], psTemp[256], fsInUse[256];
    ULONG i, exitval, beginSect, endSect;
    PFUNCRETURN pfr;
    BOOL isHPFS;
    BOOL freeSpace, badSecs, sysUsage, toggleDirty,
         setDirty, newDirty, optChosen, getDirty,
         dumpSects, showSuper, showSpare, fullDBList,
         noLineChars;

    freeSpace=FALSE;
    badSecs=FALSE;
    sysUsage=FALSE;
    getDirty=FALSE;
    toggleDirty=FALSE;
    setDirty=FALSE;
    newDirty=FALSE;
    dumpSects=FALSE;
    showSuper=FALSE;
    showSpare=FALSE;
    fullDBList=FALSE;
    optChosen=FALSE;

    noLineChars=FALSE;
    driveString[0]=0x00;
    dfName[0]=0x00;

    if (argc<3)
        {
        Usage(NULL);
        return FAIL_USAGE;
        }

    exitval=0;

    memset(psTemp, 0, sizeof(psTemp));

    for (i=1; i<argc; i++)
        {
        if (argv[i][0]=='/' || argv[i][0]=='-')
            {
            if (strlen(argv[i])==2)
                {
                if (argv[i][1]=='?')
                    {
                    Usage(NULL);
                    return FAIL_USAGE;
                    }
                }
            if (strlen(argv[i])<3)
                {
                sprintf(psTemp, "Invalid option (%s).", argv[i]);
                Usage(psTemp);
                return FAIL_INVALID_OPTION;
                }
            else
                {
                UCHAR option[3];
                option[0]=toupper(argv[i][1]);
                option[1]=toupper(argv[i][2]);
                option[2]=0x00;
                if (!strcmp(option, "NL"))
                    {
                    if (noLineChars)
                        {
                        sprintf(psTemp, "Duplicate option (%s).", argv[i]);
                        Usage(psTemp);
                        return FAIL_INVALID_OPTION;
                        }
                    noLineChars=TRUE;
                    if (strlen(argv[i])>3)
                        {
                        sprintf(psTemp, "Invalid option (%s).", argv[i]);
                        Usage(psTemp);
                        return FAIL_INVALID_OPTION;
                        }
                    }
                else if (!strcmp(option, "GD"))
                    {
                    if (getDirty)
                        {
                        sprintf(psTemp, "Duplicate option (%s).", argv[i]);
                        Usage(psTemp);
                        return FAIL_INVALID_OPTION;
                        }
                    optChosen=TRUE;
                    getDirty=TRUE;
                    if (strlen(argv[i])>3)
                        {
                        sprintf(psTemp, "Invalid option (%s).", argv[i]);
                        Usage(psTemp);
                        return FAIL_INVALID_OPTION;
                        }
                    }
                else if (!strcmp(option, "DT"))
                    {
                    if (toggleDirty)
                        {
                        sprintf(psTemp, "Duplicate option (%s).", argv[i]);
                        Usage(psTemp);
                        return FAIL_INVALID_OPTION;
                        }
                    if (setDirty)
                        {
                        Usage("Incompatible option mix (set dirty and toggle dirty).");
                        return FAIL_INVALID_OPTION;
                        }
                    optChosen=TRUE;
                    toggleDirty=TRUE;
                    if (strlen(argv[i])>3)
                        {
                        sprintf(psTemp, "Invalid option (%s).", argv[i]);
                        Usage(psTemp);
                        return FAIL_INVALID_OPTION;
                        }
                    }
                else if (!strcmp(option, "FS"))
                    {
                    if (freeSpace)
                        {
                        sprintf(psTemp, "Duplicate option (%s).", argv[i]);
                        Usage(psTemp);
                        return FAIL_INVALID_OPTION;
                        }
                    optChosen=TRUE;
                    freeSpace=TRUE;
                    if (strlen(argv[i])>3)
                        {
                        sprintf(psTemp, "Invalid option (%s).", argv[i]);
                        Usage(psTemp);
                        return FAIL_INVALID_OPTION;
                        }
                    }
                else if (!strcmp(option, "SU"))
                    {
                    if (sysUsage)
                        {
                        sprintf(psTemp, "Duplicate option (%s).", argv[i]);
                        Usage(psTemp);
                        return FAIL_INVALID_OPTION;
                        }
                    optChosen=TRUE;
                    sysUsage=TRUE;
                    if (strlen(argv[i])>3)
                        {
                        sprintf(psTemp, "Invalid option (%s).", argv[i]);
                        Usage(psTemp);
                        return FAIL_INVALID_OPTION;
                        }
                    }
                else if (!strcmp(option, "BS"))
                    {
                    if (badSecs)
                        {
                        sprintf(psTemp, "Duplicate option (%s).", argv[i]);
                        Usage(psTemp);
                        return FAIL_INVALID_OPTION;
                        }
                    optChosen=TRUE;
                    badSecs=TRUE;
                    if (strlen(argv[i])>3)
                        {
                        sprintf(psTemp, "Invalid option (%s).", argv[i]);
                        Usage(psTemp);
                        return FAIL_INVALID_OPTION;
                        }
                    }
                else if (!strcmp(option, "SH"))
                    {
                    UCHAR argtemp[256];
                    optChosen=TRUE;
                    strcpy(argtemp, argv[i]);
                    RightJustify(argtemp, strlen(argtemp)-3);
                    if (!stricmp(argtemp, "SU"))
                        {
                        if (showSuper)
                            {
                            sprintf(psTemp, "Duplicate option (%s).", argv[i]);
                            Usage(psTemp);
                            return FAIL_INVALID_OPTION;
                            }
                        showSuper=TRUE;
                        }
                    else if (!stricmp(argtemp, "SP"))
                        {
                        if (showSpare)
                            {
                            sprintf(psTemp, "Duplicate option (%s).", argv[i]);
                            Usage(psTemp);
                            return FAIL_INVALID_OPTION;
                            }
                        showSpare=TRUE;
                        }
                    else if (!stricmp(argtemp, "SPFD"))
                        {
                        if (showSpare)
                            {
                            sprintf(psTemp, "Duplicate option (%s).", argv[i]);
                            Usage(psTemp);
                            return FAIL_INVALID_OPTION;
                            }
                        showSpare=TRUE;
                        fullDBList=TRUE;
                        }
                    else
                        {
                        sprintf(psTemp, "Invalid option (%s).", argv[i]);
                        Usage(psTemp);
                        return FAIL_INVALID_OPTION;
                        }
                    }
                else if (!strcmp(option, "DS"))
                    {
                    UCHAR argtemp[256];
                    if (dumpSects)
                        {
                        sprintf(psTemp, "Duplicate option (%s).", argv[i]);
                        Usage(psTemp);
                        return FAIL_INVALID_OPTION;
                        }
                    optChosen=TRUE;
                    dumpSects=TRUE;
                    if (strlen(argv[i])<5)
                        {
                        sprintf(psTemp, "Invalid option (%s).", argv[i]);
                        Usage(psTemp);
                        return FAIL_INVALID_OPTION;
                        }
                    strcpy(argtemp, argv[i]);
                    RightJustify(argtemp, strlen(argtemp)-4);
                    pfr=ParseSectValues(argtemp, &beginSect, &endSect);
                    if (!pfr->success)
                        {
                        if (!strcmp(pfr->errorFunc, "endbeforebegin"))
                            {
                            sprintf(psTemp, "End sector (%u) precedes begin sector (%u).",
                                   endSect, beginSect);
                            }
                        else
                            {
                            sprintf(psTemp, "Invalid sector number (%s).", pfr->errorFunc);
                            }
                        Usage(psTemp);
                        return FAIL_INVALID_OPTION;
                        }
                    }
                else if (!strcmp(option, "FN"))
                    {
                    FILE *tfile;
                    if (strlen(dfName)>0)
                        {
                        sprintf(psTemp, "Duplicate option (%s).", argv[i]);
                        Usage(psTemp);
                        return FAIL_INVALID_OPTION;
                        }
                    if (strlen(argv[i])<5)
                        {
                        sprintf(psTemp, "Invalid option (%s).", argv[i]);
                        Usage(psTemp);
                        return FAIL_INVALID_OPTION;
                        }
                    strcpy(dfName, argv[i]);
                    RightJustify(dfName, strlen(dfName)-4);
                    tfile=fopen(dfName, "wb");
                    if (tfile==NULL)
                        {
                        sprintf(psTemp, "Invalid filename (%s) specified.", dfName);
                        Usage(psTemp);
                        return FAIL_INVALID_OPTION;
                        }
                    else
                        {
                        fclose(tfile);
                        DosDelete(dfName);
                        }
                    }
                else if (!strcmp(option, "SD"))
                    {
                    if (setDirty)
                        {
                        sprintf(psTemp, "Duplicate option (%s).", argv[i]);
                        Usage(psTemp);
                        return FAIL_INVALID_OPTION;
                        }
                    if (toggleDirty)
                        {
                        Usage("Incompatible option mix (set dirty and toggle dirty).");
                        return FAIL_INVALID_OPTION;
                        }
                    if (strlen(argv[i])!=5)
                        {
                        sprintf(psTemp, "Invalid option (%s).", argv[i]);
                        Usage(psTemp);
                        return FAIL_INVALID_OPTION;
                        }
                    optChosen=TRUE;
                    setDirty=TRUE;
                    if (toupper(argv[i][4])=='T')
                        newDirty=TRUE;
                    else if (toupper(argv[i][4])=='F')
                        newDirty=FALSE;
                    else
                        {
                        sprintf(psTemp, "Invalid option (%s).", argv[i]);
                        Usage(psTemp);
                        return FAIL_INVALID_OPTION;
                        }
                    }
                }
            }
        else if (strlen(argv[i])==2)
            {
            if (argv[i][1]==':')
                {
                if (toupper(argv[i][0])<65 || toupper(argv[i][0])>90)
                    {
                    sprintf(psTemp, "Invalid drive string (%s) provided.", argv[i]);
                    Usage(psTemp);
                    return FAIL_BAD_DRIVE_STRING;
                    }
                else
                    {
                    if (strlen(driveString)>0)
                        {
                        sprintf(psTemp, "Duplicate drive string (%s) provided.", argv[i]);
                        Usage(psTemp);
                        return FAIL_BAD_DRIVE_STRING;
                        }
                    strcpy(driveString, argv[i]);
                    }
                }
            else
                {
                sprintf(psTemp, "Invalid option (%s).", argv[i]);
                Usage(psTemp);
                return FAIL_INVALID_OPTION;
                }
            }
        else
            {
            sprintf(psTemp, "Invalid option (%s).", argv[i]);
            Usage(psTemp);
            return FAIL_INVALID_OPTION;
            }
        }

    if (!optChosen)
        {
        Usage("No options specified.");
        return FAIL_INVALID_OPTION;
        }

    if (strlen(driveString)==0)
        {
        Usage("No drive specified.");
        return FAIL_INVALID_OPTION;
        }

    memset(fsInUse, 0, sizeof(fsInUse));
    pfr=DriveIsHPFS(driveString, &isHPFS, fsInUse);
    if (!pfr->success || !isHPFS)
        {
        sprintf(psTemp, "Specified drive (%s) is not using HPFS (OS/2 says it's \"%s\").", driveString, fsInUse);
        Usage(psTemp);
        return FAIL_NOT_HPFS;
        }

    if (freeSpace)
        {
        PFREESPACEINFO fsi;
        fsi=(PFREESPACEINFO)malloc(sizeof(FREESPACEINFO));
        pfr=GetRealFreeSpace(driveString, fsi);
        if (!pfr->success)
            {
            printf("\nAn error was encountered while acquiring freespace information.\n");
            ReportError(pfr);
            exitval=FAIL_ONE_OR_MORE_FAILURES;
            }
        else
            {
            ShowFreeSpaceInfo(fsi, toupper(driveString[0]), noLineChars);
            }
        free(fsi);
        }

    if (getDirty)
        {
        BOOL dStatus;
        pfr=GetDirtyStatus(driveString, &dStatus);
        if (!pfr->success)
            {
            printf("\nAn error was encountered while determining the dirty status of the drive.\n");
            ReportError(pfr);
            exitval=FAIL_ONE_OR_MORE_FAILURES;
            }
        else
            {
            printf("\nDrive %c: is ", toupper(driveString[0]));
            if (dStatus)
                printf("dirty.\n");
            else
                printf("clean.\n");
            }
        }

    if (toggleDirty)
        {
        BOOL dStatus;
        pfr=ToggleDirtyStatus(driveString, &dStatus);
        if (!pfr->success)
            {
            printf("\nAn error was encountered while toggling the dirty status of the drive.\n");
            ReportError(pfr);
            exitval=FAIL_ONE_OR_MORE_FAILURES;
            }
        else
            {
            printf("\nDrive %c: was ", toupper(driveString[0]));
            if (dStatus)
                printf("clean; set to dirty.\n");
            else
                printf("dirty; set to clean.\n");
            }
        }

    if (setDirty)
        {
        pfr=SetDirtyStatus(driveString, newDirty);
        if (!pfr->success)
            {
            printf("\nAn error was encountered while toggling the dirty status of the drive.\n");
            ReportError(pfr);
            exitval=FAIL_ONE_OR_MORE_FAILURES;
            }
        else
            {
            printf("\nDrive %c: has been set to ", toupper(driveString[0]));
            if (newDirty)
                printf("dirty.\n");
            else
                printf("clean.\n");
            }
        }

    if (badSecs)
        {
        ULONG bsCount;
        pfr=GetBadSectorCount(driveString, &bsCount);
        if (!pfr->success)
            {
            printf("\nAn error was encountered while determining the bad sector count.\n");
            ReportError(pfr);
            exitval=FAIL_ONE_OR_MORE_FAILURES;
            }
        else
            {
            printf("\nDrive %c: has ", toupper(driveString[0]));
            if (bsCount==0)
                printf("no bad sectors.\n");
            else if (bsCount==1)
                printf("1 bad sector.\n");
            else
                printf("%s bad sectors.\n", iCodel(bsCount));
            }
        }

    if (dumpSects)
        {
        FILE *outFile;
        ULONG sectorSize;
        if (strlen(dfName)==0)
            strcpy(dfName, "sectdata.dat");
        outFile=fopen(dfName, "wb");
        if (outFile==NULL)
            {
            printf("\nUnable to open sector dump file (%s).\n", dfName);
            exitval=FAIL_ONE_OR_MORE_FAILURES;
            }
        else
            {
            pfr=DumpSectorData(driveString, beginSect, endSect, outFile, &sectorSize);
            if (!pfr->success)
                {
                printf("\nAn error occurred while attempting to dump sectors to file.\n");
                ReportError(pfr);
                exitval=FAIL_ONE_OR_MORE_FAILURES;
                }
            else
                {
                printf("\n%s sectors (%s bytes) dumped to file %s.\n",
                       iCodel(endSect-beginSect+1),
                       fCodel((double)(endSect-beginSect+1)*(double)sectorSize),
                       dfName);
                }
            fclose(outFile);
            }
        }

    if (sysUsage)
        {
        SYSTEMUSAGE su;
        pfr=GetSystemUsage(driveString, &su);
        if (!pfr->success)
            {
            printf("\nAn error was encountered while tallying HPFS system usage.\n");
            ReportError(pfr);
            exitval=FAIL_ONE_OR_MORE_FAILURES;
            }
        else
            ShowSystemUsage(toupper(driveString[0]), &su, noLineChars);
        }

    if (showSuper)
        {
        HFILE driveHandle;
        ULONG sectorSize;
        PSUPERBLOCK sub=NULL;
        pfr=OpenDrive(driveString, &driveHandle, 0L);
        if (!pfr->success)
            {
            printf("\nAn error was encountered while attempting to read the SuperBlock.\n");
            ReportError(pfr);
            exitval=FAIL_ONE_OR_MORE_FAILURES;
            }
        else
            {
            pfr=GetDriveSpecs(driveHandle, &sectorSize, NULL);
            if (!pfr->success)
                {
                printf("\nAn error was encountered while attempting to read the SuperBlock.\n");
                ReportError(pfr);
                exitval=FAIL_ONE_OR_MORE_FAILURES;
                }
            else
                {
                sub=(PSUPERBLOCK)malloc(sectorSize);
                if (sub==NULL)
                    {
                    printf("\nUnable to allocate memory for SuperBlock.\n");
                    exitval=FAIL_ONE_OR_MORE_FAILURES;
                    }
                else
                    {
                    pfr=ReadSuperBlock(driveHandle, sub);
                    if (!pfr->success)
                        {
                        printf("\nAn error was encountered while attempting to read the SuperBlock.\n");
                        ReportError(pfr);
                        exitval=FAIL_ONE_OR_MORE_FAILURES;
                        }
                    else
                        ShowSuperBlock(sub, sectorSize, toupper(driveString[0]), noLineChars);
                    }
                }
            }
        free(sub);
        }

    if (showSpare)
        {
        HFILE driveHandle;
        ULONG sectorSize;
        PSPAREBLOCK spb=NULL;
        pfr=OpenDrive(driveString, &driveHandle, 0L);
        if (!pfr->success)
            {
            printf("\nAn error was encountered while attempting to read the SpareBlock.\n");
            ReportError(pfr);
            exitval=FAIL_ONE_OR_MORE_FAILURES;
            }
        else
            {
            pfr=GetDriveSpecs(driveHandle, &sectorSize, NULL);
            if (!pfr->success)
                {
                printf("\nAn error was encountered while attempting to read the SpareBlock.\n");
                ReportError(pfr);
                exitval=FAIL_ONE_OR_MORE_FAILURES;
                }
            else
                {
                spb=(PSPAREBLOCK)malloc(sectorSize);
                if (spb==NULL)
                    {
                    printf("\nUnable to allocate memory for SpareBlock.\n");
                    exitval=FAIL_ONE_OR_MORE_FAILURES;
                    }
                else
                    {
                    pfr=ReadSpareBlock(driveHandle, spb);
                    if (!pfr->success)
                        {
                        printf("\nAn error was encountered while attempting to read the SpareBlock.\n");
                        ReportError(pfr);
                        exitval=FAIL_ONE_OR_MORE_FAILURES;
                        }
                    else
                        ShowSpareBlock(spb, sectorSize, toupper(driveString[0]), fullDBList, noLineChars);
                    }
                }
            }
        free(spb);
        }

    return exitval;
}
