/* $Id: attrs.h,v 1.11 2005/02/11 17:16:12 root Exp $
 *
 * Derived from a certain package called SIGuardian, and SU.HARDW.PC.MEDIA
 * FidoNet conference. Updated listings by Vladislav Shaklein and
 * Michail Mavritsin.
 */

#ifndef ATTRS_INCLUDED
#define ATTRS_INCLUDED

#include <stddef.h>

#define FAMILY_FUJITSU          0x0001  /* Fujitsu */
#define FAMILY_IBM              0x0002  /* IBM */
#define FAMILY_HGST         FAMILY_IBM  /* No stats for Hitachi so far */
#define FAMILY_WD               0x0004  /* Western Digital */
#define FAMILY_QUANTUM          0x0008  /* Quantum */
#define FAMILY_MAXTOR           0x0010  /* Maxtor */
#define FAMILY_QUAXTOR          (FAMILY_QUANTUM|FAMILY_MAXTOR)
#define FAMILY_CONNER           0x0020  /* Conner */
#define FAMILY_SEAGATE          0x0040  /* Seagate */
#define FAMILY_CONNERGATE       (FAMILY_CONNER|FAMILY_SEAGATE)
#define FAMILY_SAMSUNG          0x0080  /* Samsung */
#define FAMILY_ALL              0xFFFF  /* Generic/common */

/* S.M.A.R.T. attribute description */

struct SMARTATTR
{
 unsigned short num;
 unsigned short family;
 char *name;
};

#define ATTR_NAME_MAX               32

static struct SMARTATTR std_attrs[]=
{
 {  1, FAMILY_ALL, "Raw Read Error Rate"},
 {  2, FAMILY_ALL, "Throughput Performance"},
 {  3, FAMILY_ALL, "Spin Up Time"},
 {  4, FAMILY_ALL, "Start/Stop Count"},
 {  5, FAMILY_ALL, "Reallocated Sector Count"},
 {  6, FAMILY_MAXTOR, "Read channel margin"},
 {  7, FAMILY_ALL, "Seek Error Rate"},
 {  8, FAMILY_ALL, "Seek Time Performance"},
 {  9, FAMILY_ALL, "Power On Time Count"},
 { 10, FAMILY_WD|FAMILY_QUAXTOR, "Emergency Spindown-Spinup"},
 { 10, FAMILY_ALL, "Spin Retry Count"},
 { 11, FAMILY_ALL, "Recalibration Retries"},
 { 12, FAMILY_ALL, "Drive Power Cycle Count"},
 { 13, FAMILY_ALL, "Soft Read Error Rate"},
 {191, FAMILY_IBM, "Gsense Error Rate"},
 {192, FAMILY_IBM, "Power Off Retract Count"},
 {192, FAMILY_WD, "PI->AI Transitions"}, /* Scorpio: 300-ms timeouts */
 {193, FAMILY_IBM, "Load/Unload Cycle Count"},
 {193, FAMILY_WD, "PI->AI+LPI Transitions"}, /* Scorpio: 300-ms + 5000-ms timeouts */
 {194, FAMILY_ALL, "Drive Temperature"},
 {195, FAMILY_ALL, "Hardware ECC Recovered"},
 {196, FAMILY_ALL, "Reallocation Event Count"},
 {197, FAMILY_ALL, "Pending Sector Count"},
 {198, FAMILY_ALL, "Uncorrectable Sectors"},
 {199, FAMILY_ALL, "Ultra ATA CRC Error Rate"},
 {200, FAMILY_WD|FAMILY_SAMSUNG, "Multi-Zone Error Rate"},
 {200, FAMILY_FUJITSU|FAMILY_IBM|FAMILY_SAMSUNG, "Write Error Rate"},
 {201, FAMILY_MAXTOR, "TA Counter Detected"},
 {201, FAMILY_SAMSUNG, "Soft Error Tracking"},
 {202, FAMILY_MAXTOR, "TA Counter Increased"},
 {207, FAMILY_QUAXTOR, "Spindown Count A"},   /* ? Contributes to overall spin retry count */
 {208, FAMILY_QUAXTOR, "Spindown Count B"},   /* ? Contributes to overall spin retry count */
 {220, FAMILY_IBM, "Disk Shift"},
 {221, FAMILY_IBM, "G-Sense Error Rate"},
 {222, FAMILY_IBM, "Loaded Hours"},
 {223, FAMILY_IBM, "Load Retry Count"},
 {224, FAMILY_IBM, "Load Friction"},
 {225, FAMILY_IBM, "Load Cycle Count"},
 {226, FAMILY_IBM, "Load-in Time"},
 {227, FAMILY_IBM, "Torque Amp Count"},
 {228, FAMILY_IBM, "Power-off Retract Count"},
 {230, FAMILY_IBM, "GMR Head Amplitude"},
 {231, FAMILY_IBM, "Board Temperature"},
 {240, FAMILY_HGST, "Head Flying Hours"},
 {250, FAMILY_HGST, "Read Error Retry Rate"},
 {  0, 0, NULL}
};

#endif
