/* Doublico */

CALL RxFuncAdd 'DoublicoFileCompare','Doublico','DoublicoFileCompare'
CALL RxFuncAdd 'DoublicoFileCRC32X','Doublico','DoublicoFileCRC32X'
CALL RxFuncAdd 'SysCls','RexxUtil','SysCls'
CALL RxFuncAdd 'SysCreateObject','RexxUtil','SysCreateObject'
CALL RxFuncAdd 'SysCurPos','RexxUtil','SysCurPos'
CALL RxFuncAdd 'SysDestroyObject','RexxUtil','SysDestroyObject'
CALL RxFuncAdd 'SysFileTree','RexxUtil','SysFileTree'
CALL RxFuncAdd 'SysSearchPath','RexxUtil','SysSearchPath'

IF KillIco(1)=1 THEN EXIT

CALL SysCls
SAY
SAY

aanmaak=0

SIGNAL ON Halt

/* Afhandelen argumenten */

PARSE ARG optie

origineel=optie

IF optie='' THEN optie=Value('ICONLIB',,'ENVIRONMENT')

IF Left(optie,1)='"' THEN PARSE VAR optie '"' optie '"'

ext=Value('DOUBLICO',,'ENVIRONMENT')
IF ext='' THEN ext='ICO'

IF optie='' | optie='/?' | optie='-?' THEN DO
   CALL CharOut '','Doublico zoekt naar identieke bestanden met de extensie *.'
   SAY ext||'.'
   SAY 'Gevonden identieke bestanden worden in een Map gezet, zodat u'
   SAY 'zelf kunt kiezen welke bestanden u wilt behouden.'
   SAY
   SAY 'Voor te verwijderen bestanden wordt een Map met daarin, onder'
   SAY 'andere, KillIco aangemaakt. Sleep de overbodige bestanden naar'
   SAY 'KillIco in plaats van naar de Vernietiger. Verwijder daarna de'
   SAY 'door Doublico aangemaakte Map met daarin de bestanden die u'
   SAY 'wilt bewaren.'
   SAY
   SAY '   Syntax :'
   SAY
   SAY '      DOUBLICO <path>'
   SAY '      DOUBLICO [/?|-?]'
   SAY
   SAY 'Waarbij <path> de directory aangeeft waaronder uw Iconen-bibliotheek'
   SAY 'te vinden is. Met de optie /? of -? roept u dit scherm op.'
   SAY
   EXIT
END

SAY '   |   Doublico kan ook gebruikt worden voor andere bestandtypes dan het'
SAY '   |   standaard "*.ICO" door dat als volgt op te geven in CONFIG.SYS:'
SAY '   |'
SAY '   |      SET DOUBLICO='||ext
SAY

/* Controle argumenten en opvragen bestandenlijst */

rc=SysFileTree(optie,controle,DO)

IF rc=2 THEN DO
   SAY 'Doublico heeft geconstateerd dat er onvoldoende geheugen beschikbaar is'
   SAY 'om een tabel met bestanden aan te kunnen maken.'
   SAY
   SAY 'Het programma heeft niets verwerkt.'
   SAY
   EXIT
END

IF controle.0=0 THEN DO
   SAY 'Doublico heeft geen directory gevonden die voldoet aan het opgegeven'
   SAY 'profiel:' optie
   SAY
   SAY 'Als de directory wel bestaat moet u een directory opgeven die een'
   SAY 'nivo hoger zit, bijvoorbeeld C:\OS2 in plaats van C:\OS2\ICONS.'
   SAY 'De opgegeven directory moet tenminste 1 subdirectory bevatten.'
   SAY
   SAY 'Het programma heeft niets verwerkt.'
   SAY
   EXIT
END

IF Right(optie,1)<>'\' THEN optie=optie||'\'

optie=optie||'*.'||ext

CALL CharOut '','Doublico zoekt nu naar bestanden met de extensie *.'
SAY ext||'.'
SAY
SAY

rc=SysFileTree(optie,'icon','FOS')

IF rc=2 THEN DO
   SAY 'Doublico heeft geconstateerd dat er onvoldoende geheugen beschikbaar is'
   SAY 'om een tabel met bestanden aan te kunnen maken.'
   SAY
   SAY 'Het programma heeft niets verwerkt.'
   SAY
   EXIT
END

IF icon.0=1 THEN DO
   SAY 'Doublico heeft onder de opgegeven directory niet voldoende bestanden'
   SAY 'aangetroffen om vergelijkingen te kunnen maken.'
   SAY
   SAY 'Het programma heeft niets verwerkt.'
   SAY
   EXIT
END

IF icon.0=0 THEN DO
   SAY 'Doublico heeft onder de opgegeven directory geen bestanden gevonden'
   SAY 'met de extensie *.'||ext||'.'
   SAY
   SAY 'Het programma heeft niets verwerkt.'
   SAY
   EXIT
END

IF origineel<>'' THEN DO
   IF Value('ICONLIB',,'ENVIRONMENT')='' THEN DO
      SAY '   |   Doublico kan standaard met de opgegeven directory werken door'
      SAY '   |   in CONFIG.SYS deze regel op te nemen :'
      SAY '   |'
      SAY '   |      SET ICONLIB='||origineel
      SAY '   |'
      SAY '   |   Deze standaardwaarde wordt niet gebruikt wanneer DOUBLICO.CMD'
      SAY '   |   wordt gestart met een (andere) directory als parameter.'
      SAY
      SAY
   END
END

/* Vaststellen gegevens per bestand */

CALL CharOut '','Er zijn' icon.0 'bestanden gevonden met de extensie *.'
SAY ext||'.'
SAY
SAY 'Voor alle aangetroffen bestanden wordt nu een indexwaarde bepaald. Bij'
SAY 'veel bestanden, of bij relatief weinig beschikbare hardware-capaciteit,'
SAY 'kan dit lang duren. Met <CTRL-BREAK> kunt u de verwerking onderbreken.'
SAY

omvang.0=icon.0
crc32x.0=icon.0

DO i=1 TO icon.0
   crc32x.i=DoublicoFileCRC32X(icon.i)
END i

/* Zoeken naar gelijke bestanden */

CALL SysCls

SAY
SAY
SAY 'Doublico zoekt nu naar dubbele bestanden. Bij veel bestanden, of bij'
SAY 'relatief weinig beschikbare hardware-capaciteit, kan dit lang duren.'
SAY
SAY 'Met <CTRL-BREAK> kan de verwerking voortijdig onderbroken worden,'
SAY 'waarbij de Map "Doublico" op de Werkplek (indien aangemaakt) ver-'
SAY 'wijderd mag worden.'

aangemaakt=0
mappen=1

DO i=1 TO (icon.0)-1
   PARSE VALUE SysCurPos() WITH cury curx
   SAY Format(i/(icon.0)*100,4,0)||'% gecontroleerd...'
   CALL SysCurPos cury,curx
   IF crc32x.i<>'' THEN DO
      enkel=0
      DO j=(i+1) TO icon.0
         IF crc32x.j<>'' THEN DO
            IF crc32x.i=crc32x.j THEN DO
               IF DoublicoFileCompare(icon.i,icon.j)=0 THEN DO
                  aanmaak=aanmaak+1
                  IF aanmaak=1 THEN DO
                     IF Map('Doubloci')=1 THEN EXIT
                     IF Map('Doubloci'||mappen)=1 THEN EXIT
                  END
                  enkel=enkel+1
                  IF enkel=1 THEN DO
                     IF aangemaakt=0 THEN DO
                        IF aanmaak>1 THEN DO
                           IF Map('Doubloci'||mappen)=1 THEN EXIT
                        END
                     END
                     IF Bestand(icon.i,icon.j,'Doubloci'||mappen)=1 THEN EXIT
                     aangemaakt=aangemaakt+2
                  END
                  IF enkel>1 THEN DO
                     IF Bestand('',icon.j,'Doubloci'||mappen)=1 THEN EXIT
                     aangemaakt=aangemaakt+1
                  END
               crc32x.j=''
               END
            END
         END
      END j
   END
   IF aangemaakt>39 THEN DO
      mappen=mappen+1
      aangemaakt=0
   END
END i

CALL SysCls

SAY
SAY

IF aanmaak=0 THEN DO
   SAY 'Doublico heeft geen identieke bestanden aangetroffen.'
   SAY
   EXIT
END

SAY 'Doublico heeft' aanmaak 'keer identieke bestanden aangetroffen, die'
SAY 'op de Werkplek in de Map "Doublico" zijn geplaatst. Dubbele be-'
SAY 'standen, die verwijderd mogen worden, moet u slepen naar het'
SAY 'programma "KillIco", wat bij Doublico hoort.'
SAY
SAY 'De overige bestanden behoudt u door de Map "Doublico", inclusief'
SAY 'alle bestanden die daarin staan, te wissen. Het origineel van de'
SAY 'te bewaren bestanden blijft gewoon aanwezig.'

EXIT


Bestand: PROCEDURE
   PARSE ARG icon1,icon2,lokatie
   IF icon1<>'' THEN DO
      setup1='SHADOWID='||icon1||';'
      rc=SysCreateObject('WPShadow',icon1,'<'||lokatie||'>',setup1,'ReplaceIfExists')
      IF rc=0 THEN RETURN 1
   END
   setup2='SHADOWID='||icon2||';'
   rc=SysCreateObject('WPShadow',icon2,'<'||lokatie||'>',setup2,'ReplaceIfExists')
   IF rc=0 THEN RETURN 1
RETURN 0


KillIco: PROCEDURE
   ARG kinit
   kaanwezig=Stream('KILLICO.CMD','C','QUERY EXISTS')
   IF kaanwezig='' THEN DO
      SAY 'KILLICO.CMD, een onderdeel van Doublico, staat niet in de'
      SAY 'huidige directory. Het programma is gestopt.'
      SAY
      RETURN 1
   END
   IF kinit=1 THEN RETURN 0
   kclass='WPProgram'
   ktitel='KillIco'
   klokatie='<Doubloci>'
   ksetup='EXENAME='||Directory()||'\KILLICO.CMD;PARAMETERS="%*";'
   kaktie='ReplaceIfExists'
   krc=SysCreateObject(kclass,ktitel,klokatie,ksetup,kaktie)
   IF krc=0 THEN RETURN 1
RETURN 0


Map: PROCEDURE
   PARSE ARG maptitel
   lokatie='Doubloci'
   IF maptitel='Doubloci' THEN DO
      lokatie='WP_DESKTOP'
      SAY
   END
   lokatie='<'||lokatie||'>'
   setup='OBJECTID=<'||maptitel||'>;ICONVIEW=FLOWED;'
   rc=SysCreateObject('WPFolder','Doublico'||SubStr(maptitel,9),lokatie,setup,'ReplaceIfExists')
   IF rc=1 THEN DO
      IF lokatie='<WP_DESKTOP>' THEN DO
         SAY 'Op de Werkplek is een Map aangemaakt voor dubbele bestanden.'
         IF KillIco()=1 THEN DO
            SAY 'Er kan geen programma-Object worden aangemaakt voor KillIco.'
            SAY 'Het programma wordt afgebroken. De aangemaakte Mappen worden'
            SAY 'nu verwijderd, indien mogelijk.'
            SAY
            CALL SysDestroyObject '<Doubloci>'
            EXIT
         END
      END
   END
   IF rc=1 THEN RETURN 0
   SAY 'Er kan geen Map worden aangemaakt voor Doublico. Het programma'
   SAY 'wordt afgebroken.'
   SAY
RETURN 1


Halt:
CALL SysCls
SAY
SAY
IF aanmaak=0 THEN DO
   SAY 'Het programma is onderbroken, en heeft niets verwerkt.'
   SAY
   EXIT
END
SAY 'Het programma is onderbroken.'
SAY
SAY 'Doublico heeft identieke bestanden aangetroffen, die op de Werkplek'
SAY 'in de Map "Doublico" zijn geplaatst. Dubbele bestanden, die verwij-'
SAY 'derd mogen worden, moet u slepen naar het programma "KillIco", wat'
SAY 'bij Doublico hoort.'
SAY
SAY 'De overige bestanden behoudt u door de Map "Doublico", inclusief'
SAY 'alle bestanden die daarin staan, te wissen. Het origineel van de'
SAY 'te bewaren bestanden blijft gewoon aanwezig.'
SAY
EXIT
