/*
 * LOGFILE.c
 *
 * Logdatei und Funktionen darauf
 *
 * Autor: SG
 * Stand: 22.6.93
 *
 */

#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>

FILE *LOFile;

void LOClose(void)
{
    if (LOFile)
	fclose(LOFile);
}

static int LOOpen(const char *Logfilename,const char *mode)
{
    if (Logfilename == NULL)
	return 0;

    LOFile = fopen(Logfilename,mode);
    if (LOFile == NULL)
	return 0;

    atexit(LOClose);
    return 1;
}

int LOInit(const char *Logfilename)
{
    return LOOpen(Logfilename,"w");
}

int LOAppend(const char *Logfilename)
{
    return LOOpen(Logfilename,"a");
}

static int LOWrite(const char *Format,va_list vl)
{
    vfprintf(stdout,Format,vl);
    fputs("\n",stdout);
    if (LOFile)
    {
	vfprintf(LOFile,Format,vl);
	fputs("\n",LOFile);
    }
    return 1;
}

int LOItem(const char *Format,...)
{
    va_list vl;

    va_start(vl,Format);
    LOWrite(Format,vl);
    va_end(vl);
    return 1;
}

void ERFatal(const char *Format,...)
{
    va_list vl;

    va_start(vl,Format);
    fprintf(stdout,"Fatal: ");
    if (LOFile)
	fprintf(LOFile,"Fatal: ");
    LOWrite(Format,vl);
    va_end(vl);
    exit(1);
}

int ERMessage(const char *Format,...)
{
    va_list vl;

    va_start(vl,Format);
    fprintf(stdout,"Message: ");
    if (LOFile)
	fprintf(LOFile,"Message: ");
    LOWrite(Format,vl);
    va_end(vl);
    return 1;
}
