/*
 * TREELOAD.h
 *
 * Routinen zum einlesen und Bearbeiten von
 * Verzeichnisbumen.
 *
 * Autor: SG
 * Stand: 25.1.93
 *
 */

#ifndef __TREELOAD_H
#define __TREELOAD_H

#define INCL_DOS
#define INCL_NOPM
#include <os2.h>

#define TREQUAL     0
#define TRNEWER     1
#define TROLDER     2
#define TRNEWSRC    3
#define TRNEWDEST   4


typedef struct trentry {
    struct trentry *next;

    char	  *File;
    FDATE	  Date;
    FTIME	  Time;
    USHORT	  Attrib;
} TREntry;

typedef struct {
    unsigned long EntryCount;
    TREntry	  *LastPos;
    const char	  *Base;
    size_t	  BaseLen;
    TREntry	  *Entries;
} TRTree;

typedef int (*TRForEachFunc)(TRTree *Tree,TREntry *File);
typedef int (*TRFuncEntry)(TRTree *TSource,TREntry *Source,TRTree *TDest,TREntry *Dest);

TRTree *TRLoadTree(const char *Directory);

int TRIsDir(TREntry *entry);

int TRForEach(TRTree *Tree,TRForEachFunc Function);

int TRCompare(TRTree *Source,TRTree *Dest,TRFuncEntry Functions[]);

int TRFree(TRTree *tree);

#endif
