/* TRE.CMD    REXX CMD by Gord Snider  v1.1  2003/01/12 */
/* PURPOSE: To walk the directory structure from the current
      directory and produce a screen display of the subdirectories.
      By default the display goes out to the leaf subdirectories.
      This behaviour can be varied by a parameter and switches.  

   SYNTAX:  TRE /?
       or   TRE [depth] [switches]

   where depth is a posiitive integer telling how many 
         levels deeper in the tree to display, and; 
   switch /? calls a simple help screen and exits;
          /S tells the routine to use spaces instead of graphics characters;
          /D shows the number of directories in each directory;
          /F shows the number of files in each directory;
          /B shows the number of bytes in each directory.
*/
if LRU() then exit
            
arg depth '/' switches

if datatype(depth, 'Number') = 1 
   then if datatype(depth, 'Whole') = 1
      then if depth > 0 
         then nop
         else do; say 'Depth must be a positive integer or null.'; exit; end
      else    do; say 'Depth must be a positive integer or null.'; exit; end
   else if depth = ''
      then nop
      else    do; say 'Depth must be a positive integer or null.'; exit; end 

if pos('?', switches) > 0 then do                                                /* display help screen  */
  do l = 1 until substr(sourceline(l), 1, 2) = '*/'
    say sourceline(l)
  end l
  exit
end  /* if */

current = directory()                                   /* save fully qualified current directory for return */
say substr(current, lastpos('\', current) + 1)
call next current,,depth                                /* call to check for sub-directories and files */
call directory(current)
exit 0

next: procedure expose switches                         /* hide old set of variables, enable new set */
parse arg nextdir,spacer,depth                          /* spacer is the leading characters of each line */
call directory nextdir                                  /* make the passed directory the current directory */

call SysFileTree '*', 'dir.', 'DO'                      /* are subfolders here? */
do dir = 1 to dir.0                                     /* if any, make a list of them and process it */
  if dir = dir.0 then leader = d2c(192); else leader = d2c(195)
  if pos('S', switches) > 0 then leader = ' '           /* no graphics */
  if pos('D', switches) > 0 then do                     /* how many subdirectories? */
        call SysFileTree dir.dir || '\*', 'd.', 'D' 
        data = ' ' || d.0
     end
     else data = ''
  if pos('F', switches) > 0 then do                     /* how many files? */
        call SysFileTree dir.dir || '\*', 'f.', 'F'
        data = strip(data) f.0
     end
  if pos('B', switches) > 0 then do                     /* how many bytes? */
        bites = 0
        call SysFileTree dir.dir || '\*', 'f.', 'F'
        do i = 1 to f.0
           parse var f.i . . bights . . 
           bites = bites + bights
        end
        data = strip(data) commas(bites)
     end
  say spacer || ' ' || leader || substr( dir.dir, lastpos('\', dir.dir) + 1) ' ' data
  if leader = d2c(195) then leader = d2c(179); else leader = ' '
  if depth = ''        then call next dir.dir, spacer || ' ' || leader 
     else if depth > 1 then call next dir.dir, spacer || ' ' || leader, depth - 1; 
  call directory ..                                     /* step back to parent */
end dir                                                 /* back to top of dir loop */
return 0                                                /* a leaf has been reached */

commas: procedure 
arg input
output = ''
reversed = reverse(input)
do while length(reversed) > 0
   parse var reversed 1 part 4 reversed
   partfwd = reverse(part)
   if length(reversed) > 0 then partfwd = ','partfwd
   output = partfwd || output 
end /* do */
return output
