/* editor functions */
#include <stdio.h>

#ifdef VMS
#include <ssdef.h>
#include <rmsdef.h>
#include <dvidef.h>
#include <jpidef.h>
/* #include <libdef.h> */
#include <descrip.h>
#include <iodef.h>
#include <ttdef.h>
#include <stdlib.h>

#include "externs.h"
#include "window.h"
#include "sysdep.h"

int call_edt_tpu(char *file, int line, int what)
{
    char the_file[256];
    extern void edt$edit();
    extern void tpu$tpu();
    struct dsc$descriptor_s  file_desc;
    if (what == 1)  /* tpu */
      sprintf(the_file,"TPU /START=%d ", line);
    else
      the_file[0] = '\0';
    
    strcat(the_file,file);
    
    file_desc.dsc$w_length = strlen(the_file);
    file_desc.dsc$a_pointer = the_file;
    file_desc.dsc$b_class = DSC$K_CLASS_S; /* scalar, string type */
    file_desc.dsc$b_dtype = DSC$K_DTYPE_T; /* ascii string */

    if (what == 1)
      tpu$tpu(&file_desc);
    else
      edt$edit(&file_desc);

    return(1);
}

int call_emacs(char *file, int line)
{
    int status;
    char lstr[40];
    (void) sprintf(lstr,"%d",line);
    define_logical_name("EMACS_FILE_LINE",lstr);
    define_logical_name("EMACS_FILE_NAME",file);
    status = do_emacs_command();
    delete_logical_name("EMACS_FILE_NAME");
    delete_logical_name("EMACS_FILE_LINE");
    return(status);
}

void edit_cmd()
{
    char *editor, file[80], *strp;
    int status = 1;
    
    if ((editor = getenv("MOST_EDITOR")) == NULL)  editor = "EDT";
          
    strcpy(file,WIN->buf->file);
    strp = file;
    /*  lose the version number */
    while((*strp != '\0') && (*strp != ';')) strp++;
    *strp = '\0';
    
    reset_tty();
    reset_display();
    fflush(stdout);
    
    if (!strcmp(editor,"EMACS"))
      {
          status = call_emacs(file,C_LINE);
      }
    else if (!strcmp(editor,"EDT"))
      {
          status = call_edt_tpu(file,C_LINE,0);
      }
    else if (!strcmp(editor,"TPU"))
      {
          status = call_edt_tpu(file,C_LINE,1);
      }
    else message("Unknown editor.",1);
    if (status)
      {
          redraw_display();
      }
    else message("Unable to edit.",1);
}
    
#else

void edit_cmd()
  {
      ;
  }

#endif

