/*********************************************************************/
/*                                                                   */
/*  This Program Written by Paul Edwards.                            */
/*  Released to the Public Domain                                    */
/*                                                                   */
/*********************************************************************/
/*********************************************************************/
/*                                                                   */
/*  crc16.h - calculate CRC-16s.  This is NOT the Xmodem CRC!        */
/*                                                                   */
/*                                                                   */
/*  The following things are defined:                                */
/*                                                                   */
/*  crc16 - a data type that contains the information required by    */
/*          these routines.                                          */
/*                                                                   */
/*  crc16Init - initialize the crc16 structure.  This routine        */
/*          should be called before using any of the other routines  */
/*                                                                   */
/*  crc16Update - expects a parameter of an integer, which contains  */
/*          a value from 0 to 255.  You should pass an unsigned      */
/*          value within this range.                                 */
/*                                                                   */
/*  crc16Value - returns an unsigned int containing the crc value    */
/*                                                                   */
/*  crc16Highbyte - returns the high-byte of the crc                 */
/*                                                                   */
/*  crc16Lowbyte - returns the low-byte of the crc                   */
/*                                                                   */
/*                                                                   */
/*  Example:                                                         */
/*                                                                   */
/*  #include "crc16.h"                                               */
/*                                                                   */
/*  CRC16 crc;                                                       */
/*                                                                   */
/*  crc16Init(crc);                                                  */
/*  crc16Update(crc, 'C');                                           */
/*  crc16Update(crc, 'R');                                           */
/*  crc16Update(crc, 'C');                                           */
/*  printf("crc is %x\n", crc16Value(crc));                          */
/*  printf("high byte is %x\n", crc16Highbyte(crc));                 */
/*  printf("low byte is %x\n", crc16Lowbyte(crc));                   */
/*                                                                   */
/*  Would print (assuming an ASCII machine):                         */
/*                                                                   */
/*  crc is 458d                                                      */
/*  high byte is 45                                                  */
/*  low byte is 8d                                                   */
/*                                                                   */
/*********************************************************************/

#ifndef CRC16_INCLUDED
#define CRC16_INCLUDED

static unsigned int crc16_tab[256] = {

 0x0000U, 0x00C0U, 0x0180U, 0x0140U, 0x0300U, 0x03C0U, 0x0280U, 0x0240U, 
 0x0600U, 0x06C0U, 0x0780U, 0x0740U, 0x0500U, 0x05C0U, 0x0480U, 0x0440U, 
 0x0C00U, 0x0CC0U, 0x0D80U, 0x0D40U, 0x0F00U, 0x0FC0U, 0x0E80U, 0x0E40U, 
 0x0A00U, 0x0AC0U, 0x0B80U, 0x0B40U, 0x0900U, 0x09C0U, 0x0880U, 0x0840U, 
 0x1800U, 0x18C0U, 0x1980U, 0x1940U, 0x1B00U, 0x1BC0U, 0x1A80U, 0x1A40U, 
 0x1E00U, 0x1EC0U, 0x1F80U, 0x1F40U, 0x1D00U, 0x1DC0U, 0x1C80U, 0x1C40U, 
 0x1400U, 0x14C0U, 0x1580U, 0x1540U, 0x1700U, 0x17C0U, 0x1680U, 0x1640U, 
 0x1200U, 0x12C0U, 0x1380U, 0x1340U, 0x1100U, 0x11C0U, 0x1080U, 0x1040U, 
 0x3000U, 0x30C0U, 0x3180U, 0x3140U, 0x3300U, 0x33C0U, 0x3280U, 0x3240U, 
 0x3600U, 0x36C0U, 0x3780U, 0x3740U, 0x3500U, 0x35C0U, 0x3480U, 0x3440U, 
 0x3C00U, 0x3CC0U, 0x3D80U, 0x3D40U, 0x3F00U, 0x3FC0U, 0x3E80U, 0x3E40U, 
 0x3A00U, 0x3AC0U, 0x3B80U, 0x3B40U, 0x3900U, 0x39C0U, 0x3880U, 0x3840U, 
 0x2800U, 0x28C0U, 0x2980U, 0x2940U, 0x2B00U, 0x2BC0U, 0x2A80U, 0x2A40U, 
 0x2E00U, 0x2EC0U, 0x2F80U, 0x2F40U, 0x2D00U, 0x2DC0U, 0x2C80U, 0x2C40U, 
 0x2400U, 0x24C0U, 0x2580U, 0x2540U, 0x2700U, 0x27C0U, 0x2680U, 0x2640U, 
 0x2200U, 0x22C0U, 0x2380U, 0x2340U, 0x2100U, 0x21C0U, 0x2080U, 0x2040U, 
 0x6000U, 0x60C0U, 0x6180U, 0x6140U, 0x6300U, 0x63C0U, 0x6280U, 0x6240U, 
 0x6600U, 0x66C0U, 0x6780U, 0x6740U, 0x6500U, 0x65C0U, 0x6480U, 0x6440U, 
 0x6C00U, 0x6CC0U, 0x6D80U, 0x6D40U, 0x6F00U, 0x6FC0U, 0x6E80U, 0x6E40U, 
 0x6A00U, 0x6AC0U, 0x6B80U, 0x6B40U, 0x6900U, 0x69C0U, 0x6880U, 0x6840U, 
 0x7800U, 0x78C0U, 0x7980U, 0x7940U, 0x7B00U, 0x7BC0U, 0x7A80U, 0x7A40U, 
 0x7E00U, 0x7EC0U, 0x7F80U, 0x7F40U, 0x7D00U, 0x7DC0U, 0x7C80U, 0x7C40U, 
 0x7400U, 0x74C0U, 0x7580U, 0x7540U, 0x7700U, 0x77C0U, 0x7680U, 0x7640U, 
 0x7200U, 0x72C0U, 0x7380U, 0x7340U, 0x7100U, 0x71C0U, 0x7080U, 0x7040U, 
 0x5000U, 0x50C0U, 0x5180U, 0x5140U, 0x5300U, 0x53C0U, 0x5280U, 0x5240U, 
 0x5600U, 0x56C0U, 0x5780U, 0x5740U, 0x5500U, 0x55C0U, 0x5480U, 0x5440U, 
 0x5C00U, 0x5CC0U, 0x5D80U, 0x5D40U, 0x5F00U, 0x5FC0U, 0x5E80U, 0x5E40U, 
 0x5A00U, 0x5AC0U, 0x5B80U, 0x5B40U, 0x5900U, 0x59C0U, 0x5880U, 0x5840U, 
 0x4800U, 0x48C0U, 0x4980U, 0x4940U, 0x4B00U, 0x4BC0U, 0x4A80U, 0x4A40U, 
 0x4E00U, 0x4EC0U, 0x4F80U, 0x4F40U, 0x4D00U, 0x4DC0U, 0x4C80U, 0x4C40U, 
 0x4400U, 0x44C0U, 0x4580U, 0x4540U, 0x4700U, 0x47C0U, 0x4680U, 0x4640U, 
 0x4200U, 0x42C0U, 0x4380U, 0x4340U, 0x4100U, 0x41C0U, 0x4080U, 0x4040U };

#define crc16Init(crc) ((*(crc)) = 0U)

#define crc16Update(crc, ch) \
    ((*(crc)) = ((*(crc)) >> 8) ^ \
    crc16_tab[(unsigned char)(((ch) ^ (*(crc))) & 0xffU)])

#define crc16Value(crc) (*(crc))

typedef unsigned int CRC16;
  
#define crc16Lowbyte(crc) ((*(crc)) & 0xffU)

#define crc16Highbyte(crc) (((*(crc)) >> 8) & 0xffU)

#endif
