/*********************************************************************/
/*                                                                   */
/*  This Program Written by Paul Edwards.                            */
/*  Released to the Public Domain                                    */
/*                                                                   */
/*********************************************************************/
/*********************************************************************/
/*                                                                   */
/*  crc32tst.c - small driver program to test crc32.h                */
/*                                                                   */
/*********************************************************************/

#include <stdio.h>

#include "crc32.h"

int main(void)
{
  CRC32 crc;        

  crc32Init(&crc);  
  crc32Update(&crc, 'C'); 
  crc32Update(&crc, 'R'); 
  crc32Update(&crc, 'C'); 
  printf("crc is %lx\n", crc32Value(&crc));
  printf("high byte is %x\n", crc32Byte1(&crc)); 
  printf("low byte is %x\n", crc32Byte4(&crc));   
  return (0);
}
