/*****************************************************************************************************************/
/*                                                                                                               */
/* Ren83toLONGNAME V1.00                                                                                         */
/*   - directories and files: rename the file name ("real name") to the LONGNAME ("Title")                       */
/*   - Ordner und Dateien: umbenennen des Dateinamens ("Echter Name") in den LONGNAME ("Objekttitel")            */
/*                                                                                                               */
/* Loss of correct filenames is (as far as I know) the result of storing data on a freshly formatted             */
/* JFS partition or FAT32 partiton (also when formatted with DFSEE) without restarting the computer (or          */
/* respectively ejecting a removeable device). If you have not restarted/ejeced you will loose your long         */
/* filenames, so try this utility.                                                                               */
/*                                                                                                               */
/* Usage:                                                                                                        */
/* Drag'nd drop a folder or file on "Ren83ToLONGNAMExxx.CMD".                                                    */
/* The content of this folder and all subfolders will be checked and renamed to LONGNAME.                        */
/*                                                                                                               */
/*                                                                                                               */
/* Ren83toLONGNAME is provided free of charge and with no warranties whatsoever.                                 */
/* YOU WILL BE SOLELY RESPONSIBLE FOR ANY DAMAGES TO YOUR COMPUTER SYSTEM OR                                     */
/* LOSS OF DATA WHEN USING THIS UTILTIY.                                                                         */
/*                                                                                                               */
/*                                                                                                               */
/* Please let me know, when Ren83toLONGNAME was useful for you: gehex.im2x@aonx.atx (without 'x'!)               */
/*                                                                                                               */
/* Look for the latest version at http://hobbes.nmsu.edu/                                                        */
/* Developed by hanno                                                                                            */
/*                                                                                                               */
/* History                                                                                                       */
/* V1.00, 08.12.2009: initial release                                                                            */
/*                                                                                                               */
/*                                                                                                               */
/*****************************************************************************************************************/



PARSE ARG mname_in
IF mname_in='' THEN EXIT


/* Load the rexxUtil functions */
call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs



/*------------------------------------------------------*/
/* laufwerk+pfad der umzubenennenden objekte behandeln: */
/*------------------------------------------------------*/
IF STREAM(mname_in,'C','QUERY EXISTS')<>'' THEN /* check ob dir oder file gesendet wurde */
  mdrivepath = DIRECTORY()  /* "file" geschickt ==> nur pfad abspeichern */
ELSE
  mdrivepath=mname_in   /* "dir" geschickt ==> einfach abspeichern */

mdrivepath=STRIP(mdrivepath,'B','"') || '\'    /* event. " (bei dirs mit leerzeichen) mssen weg und \ dazu */



/*-----------------------------------------------*/
/* ordner+dateien zhlen, anzeigen, ev. abbruch: */
/*-----------------------------------------------*/
SAY '1B'x||'[1;33;m'
SAY 'Ŀ'
SAY ' Ren83toLONGNAME V 1.00                                                      '
SAY '                                                                             '
SAY ' Rename directories and files from                                           '
SAY '   "realname" (maybe 8.3) to "title" (=LONGNAME from extended attributes EA) '
SAY ' Please look at the hints inside this file.                                  '
SAY ''
SAY '1B'x||'[0;m'


rc=SysFileTree(mdrivepath || '*',DirsTemp.,'DSO','*****')
manzdirs = DirsTemp.0
SAY manzdirs 'directories'
rc=SysFileTree(mdrivepath || '*',FilesTemp.,'FSO','*****')
manzfiles = FilesTemp.0
SAY manzfiles 'files'
SAY '   (Probabely not all of them to rename ...)'
SAY '-----------------------------------------------'
SAY

IF (manzdirs+manzfiles)=0 THEN
DO
  SAY 'No directories and files to rename. Abbort ...'
  EXIT
END

CALL CHAROUT, 'Start renaming Y/N: '
PULL answer
IF answer<>'J' & answer<>'j' & answer<>'Y' & answer<>'y' THEN EXIT


SAY
SAY 'Renaming has started. Please wait ...'


/*----------------------*/
/* log-file einrichten: */
/*----------------------*/
PARSE SOURCE . . mpgm .
mren83_log = FILESPEC('D', mpgm) || FILESPEC('P', mpgm) || 'Ren83toLONGNAME.log'
SIGNAL OFF error
"@ERASE" mren83_log
IF rc=2 | rc=1 THEN rc=0
SIGNAL ON error
rc=LINEOUT(mren83_log,,1) /* log-datei zum schreiben ffnen */
IF rc<>0 THEN SAY 'Error writing logfile. rc= ' rc
rc=LINEOUT(mren83_log, DATE() TIME() '  Starting "Ren83toLONGNAME"')
rc=LINEOUT(mren83_log, ' ')
rc=LINEOUT(mren83_log, '   **** PLEASE SEE SUMMARY AT THE END OF THIS FILE ****')
rc=LINEOUT(mren83_log, ' ')
rc=LINEOUT(mren83_log, ' ')


/*--------------------------*/
/* DIRECTORIES umbenennen:  */
/*--------------------------*/
/* REM dirs/files separat umbenennen wegen spez. behandlung der dirs (name sprich pfade ndern sich ja nach umbenennung): */
rc=LINEOUT(mren83_log, '--->Renaming directories ...')
rc=LINEOUT(mren83_log, 'Checking' manzdirs 'directories. Probabely not all of them to rename ...') /* wert stammt noch von startabfrage */
manzrendirs=0
manzerrdirs=0


RENAMEDIRS:
mschalter=0
rc = SysFileTree(mdrivepath || '*',DirsTemp.,'DSO','*****') /* dirs neu einlesen */

DO  i=1 TO DirsTemp.0
  CALL SysGetEA DirsTemp.i, ".LONGNAME", "mlongname"
  mlongname=SUBSTR(mlongname, 5) /* LongName ausmaskieren */
  mlongname=TRANSLATE(mlongname, '!', ':') /* real names werden mit "!" gespeichert ==> titel von ":" in "!" umwandeln */ 

  IF mlongname<>'' & FILESPEC("name", DirsTemp.i)<>mlongname THEN /* ... nur wenn ein Longname existiert oder dieser nicht dem filename entspricht: */
    DO
    SIGNAL OFF error

    "@RENAME" '"'DirsTemp.i'"' '"'mlongname'"' "2>>NUL 1>>NUL"
    /* REM egal ob fehler oder nicht: es muss wegen korr. pfad zu subfoldern neu eingelesen werden */
    /*     trotzdem fr stati auswerten: */
    IF rc=0 THEN
      manzrendirs=manzrendirs+1
    ELSE
      manzeffdirs=manzerrdirs+1

    rc=LINEOUT(mren83_log, DirsTemp.i ||' ---> '|| mlongname)
    SIGNAL ON error

    /* schalter ein ==> nochmals nach dirs suchen und schleife abbrechen fr nchsten durchlauf: */
    mschalter=1
    LEAVE
    END /* rename */

END /* schleife */

IF mschalter=1 THEN SIGNAL RENAMEDIRS /* nur wenn alle dirs umbenannt sind geht es weiter, sonst dirs neu einlesen und nochmals durch die schleife */


rc=LINEOUT(mren83_log, ' ')
rc=LINEOUT(mren83_log, ' ')



/*----------------------*/
/* FILES umbenennen:    */
/*----------------------*/
mversuch=1
rc=SysFileTree(mdrivepath || '*',FilesTemp.,'FSO','*****') /* files nochmals neu einlesen, da sich vermutl. die pfadnamen gendert haben */
rc=LINEOUT(mren83_log, '--->Renaming files ...')
rc=LINEOUT(mren83_log, 'Checking' FilesTemp.0 'files. Probabely not all of them to rename ...')
manzrenfiles=0

RENAMEFILES:
rc=LINEOUT(mren83_log, 'pass' mversuch '(check if errors are solved during next pass)')
manzerrfiles=0

DO i=1 TO FilesTemp.0
  IF FilesTemp.i<>'' THEN /* nur wenn noch nicht "gesperrt" (=erledigt) berarbeiten */
    DO
    CALL SysGetEA FilesTemp.i, ".LONGNAME", "mlongname"
    mlongname=SUBSTR(mlongname, 5) /* LongName ausmaskieren */
    mlongname=TRANSLATE(mlongname, '!', ':')  /* real names werden mit "!" gespeichert ==> titel von ":" in "!" umwandeln */ 
    mlongname=TRANSLATE(mlongname, '_', '%')  /* event. % im longname ersetzen */
    /* REM: event. % im real name werden beim RENAME-Befehl inkl. dem nachfolgenden Zeichen "verschluckt" --> keine Lsung gefunden, sollte aber kaum vorkommen */

    IF mlongname<>'' & mlongname<>FILESPEC('name', FilesTemp.i) THEN /* rename nur versuchen, wenn ein Longname existiert und er von File-Name abweicht */
    DO

    SIGNAL OFF error
    "@RENAME" '"'FilesTemp.i'"' '"'mlongname'"' "2>>NUL 1>>NUL"
    IF rc=0 THEN
      DO
      rc=LINEOUT(mren83_log, '  ' || FilesTemp.i ||' ---> '|| mlongname) /* log schreiben */
      FilesTemp.i=''      /* fr nchsten Versuch "sperren" da schon erledigt */    
      manzrenfiles=manzrenfiles+1
      END
    ELSE
      DO
      rc=LINEOUT(mren83_log, 'ERROR   ' || FilesTemp.i ||' ---> '|| mlongname) /* log schreiben */
      manzerrfiles=manzerrfiles+1
      END
    SIGNAL ON error

    END /* rename versuchen */
  END /* if "nicht gesperrt" */

END /* schleife */

mversuch=mversuch+1
rc=LINEOUT(mren83_log, ' ')

IF mversuch<=3 & manzerrfiles>0 THEN SIGNAL RENAMEFILES /* falls fehler vorh. trotzdem nur 3 versuche machen */



/*-------------------*/
/* renaming beendet: */
/*-------------------*/
call Beep 500, 100
SAY 'Renaming done.'
SAY '1B'x||'[1;31;m'
IF (manzerrdirs+manzerrfiles)<>0 THEN SAY (manzerrdirs+manzerrfiles) 'ERROR(S)'
SAY 'Please check the log-file "Ren83toLONGNAME.log"!'
SAY 'Renaming on harddisk: restart your computer.'
SAY 'Renaming on removable drives: eject disk'
SAY '1B'x||'[0;m'

rc=LINEOUT(mren83_log, ' ')
rc=LINEOUT(mren83_log, ' ')
rc=LINEOUT(mren83_log, '-------------------------------------------------')
rc=LINEOUT(mren83_log, DATE() TIME() '*** Renaming done ***')
rc=LINEOUT(mren83_log, ' ')
rc=LINEOUT(mren83_log, manzrendirs 'directories renamed')
rc=LINEOUT(mren83_log, manzerrdirs 'ERROR(S) renaming directories')
rc=LINEOUT(mren83_log, ' ')
rc=LINEOUT(mren83_log, manzrenfiles 'files renamed')
rc=LINEOUT(mren83_log, manzerrfiles 'ERROR(S) renaming files')
rc=Stream(mren83_log,'c','close') /* log-file schlieen */

SAY 'Press any key to leave ...'
TMP = SysGetKey()


EXIT