/*****************************************************************************
** SPath.cmd - (c) 1993 J. P. Fagerback        Released as FreeWare!        **
**                                                                          **
** Search the PATH for COM/EXE/CMD/BAT files.                               **
**                                                                          **
** This REXX 'program' will return the full filename according to Dos and   **
** OS/2 path search rules.                                                  **
**                                                                          **
** Syntax: SPath <command>                                                  **
**                                                                          **
** This code is provided on an as-is basis.  There is no warranty expressed **
** or implied in the code.  There is no official support for this code.     **
** However, you are welcome to contact me with questions or comments on the **
** code.  If you make your own changes to the code and wish to upload the   **
** modified code to a public forum, please note your modifications to the   **
** code.                                                                    **
**                                                                          **
** I can be reached through my CIS id: 100020,3415 or by mail to:           **
**                                                                          **
**     J. P. Fagerback                                                      **
**     PO Box 71 Simensbrten                                               **
**     N-1107 OSLO                                                          **
**     Norway                                                               **
**                                                                          **
*****************************************************************************/

/* Load the REXX DLL entry points */
call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

/* Parse the command */
parse arg file
parse upper var file file

EnvValue = value("PATH", , "OS2ENVIRONMENT")

Count = PathSplit(EnvValue)       /* Set DirList. */

do i = 1 to DirList.0
  Filename = DirList.i'\'file'.COM'
  if Exists(Filename) then
    do
    Say Filename
    return
    end

  Filename = DirList.i'\'file'.EXE'
  if Exists(Filename) then
    do
    Say Filename
    return
    end

  Filename = DirList.i'\'file'.CMD'
  if Exists(Filename) then
    do
    Say Filename
    return
    end

  Filename = DirList.i'\'file'.BAT'
  if Exists(Filename) then
    do
    Say Filename
    return
    end

end

say file 'not found in path'
exit


PathSplit: procedure expose DirList.
   /**
   ***  This will create a stem variable out of the semicolon-delimited
   ***  variable that is presumably retreived from a PATH or DPATH
   ***  environment.
   **/

   arg PathString .

   DirList = ''
   j = 1
   parse var PathString DirList.j ';' PathString
   do while DirList.j \= ''
      j = j + 1
      parse var PathString DirList.j ';' PathString
   end /* while */
   DirList.0 = j - 1
   return DirList.0

Exists: procedure

   arg file

   file = stream(file,c,'QUERY EXIST')
   if (file = '') then
      return 0
   else
      return 1
