/* 
   Changed a bit to be compiled under OS/2 using emx+gcc. Also -c option
   added (don't create output files if there was nothing to read from
   stdin).                    -- D.Maloff (maloff@tts.magadan.su), 1996 
*/

/*
 * Copyright (c) 1988, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef lint
static char copyright[] =
"@(#) Copyright (c) 1988, 1993\n\
	The Regents of the University of California.  All rights reserved.\n";
#endif /* not lint */

#ifndef lint
static char sccsid[] = "@(#)tee.c	8.1 (Berkeley) 6/6/93";
#endif /* not lint */

#include <sys/types.h>
#include <sys/stat.h>
#include <signal.h>
#include <errno.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifdef __EMX__ 
	#define __P(x) x
	#define DEFFILEMODE 0666
#endif

typedef struct _list {
	struct _list *next;
	int fd;
	char *name;
} LIST;
LIST *head;

int  append, create, exitval, opened = 0;

void add __P((int, char *));
void err __P((int, const char *, ...));
void openargs __P((char **));

int
main(argc, argv)
	int argc;
	char *argv[];
{
	register LIST *p;
	register int n, rval, wval;
	register char *bp;
	int ch;
	char *buf;
#define	BSIZE (8 * 1024)

	append = 0;
	while ((ch = getopt(argc, argv, "aci")) != EOF)
		switch((char)ch) {
		case 'a':
			append = 1;
			break;
		case 'c':
			create = 1;
			break;
		case 'i':
			(void)signal(SIGINT, SIG_IGN);
			break;
		case '?':
		default:
			(void)fprintf(stderr, "usage: tee [-aci] [file ...]\n");
			exit(1);
		}
	argv += optind;
	argc -= optind;

	if ((buf = malloc((u_int)BSIZE)) == NULL)
		err(1, "%s", strerror(errno));

	add(STDOUT_FILENO, "stdout");

	if(!create) openargs(argv);

	while ((rval = read(STDIN_FILENO, buf, BSIZE)) > 0) {
		if(!opened && create) openargs(argv);
		for (p = head; p; p = p->next) {
			n = rval;
			bp = buf;
			do {
				if ((wval = write(p->fd, bp, n)) == -1) {
					err(0, "%s: %s",
					    p->name, strerror(errno));
					exitval = 1;
					break;
				}
				bp += wval;
			} while (n -= wval);
		}
	}
	if (rval < 0)
		err(1, "read: %s", strerror(errno));
	exit(exitval);
}

void
openargs(argv)
	char *argv[];
{
	int fd;
	for (exitval = 0; *argv; ++argv)
		if ((fd = open(*argv, append ? O_WRONLY|O_CREAT|O_APPEND :
		    O_WRONLY|O_CREAT|O_TRUNC, DEFFILEMODE)) < 0) {
			err(0, "%s: %s", *argv, strerror(errno));
			exitval = 1;
		} else
			add(fd, *argv);
	opened = 1;
}

void
add(fd, name)
	int fd;
	char *name;
{
	LIST *p;

	if ((p = malloc((u_int)sizeof(LIST))) == NULL)
		err(1, "%s", strerror(errno));
	p->fd = fd;
	p->name = name;
	p->next = head;
	head = p;
}

#if __STDC__
#include <stdarg.h>
#else
#include <varargs.h>
#endif

void
#if __STDC__
err(int doexit, const char *fmt, ...)
#else
err(doexit, fmt, va_alist)
	int doexit;
	char *fmt;
        va_dcl
#endif
{
	va_list ap;
#if __STDC__
	va_start(ap, fmt);
#else
	va_start(ap);
#endif
	(void)fprintf(stderr, "tee: ");
	(void)vfprintf(stderr, fmt, ap);
	va_end(ap);
	(void)fprintf(stderr, "\n");
	if (doexit)
		exit(1);
}
