/**************************************************************
** REXX Code To View The File -- Called From
** Clone Cleaner 2.50 -- Author Edward March Jr.
**
** Three Parameters are:
**          FileName                    A|B     SizeInBytes
**
** i.e.     "c:\subdir\path\file.ext"   A       1234
**************************************************************/
/*
*
*/
/**************************************************************
** User Defined Programs  -- EDIT THIS SECTION
**************************************************************/
MyAsciiViewer =     "E.Exe"
MyInfViewer    =    "View.exe"
MyBinaryViewer =    "List2.Exe"
MyGraphicViewer =   "D:\Pmview\Pmview.Exe"
MyZipViewer     =   "G:\os2bin\unzip -v"
/*************************************************************/
/*
*
*/
call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs
/*
** Called as   "C:\directory\filename.ext"  B  123456
*/
parse upper arg  Parameters                                             /* Convert To uppercase */
OpenQuote = pos('"',Parameters)                                         /* Find open quote for path/filename */
CloseQuote = lastpos('"',Parameters)                                    /* Find closing quote */
FullPathName = substr(Parameters,OpenQuote+1,CloseQuote-OpenQuote-1)    /* Get path to file name */
AfterName = substr(Parameters,CloseQuote+1,256)                         /* Look for A or B (ascii or binary) */
/*
*
*/
AsciiBinary = word( AfterName, 1 )  /* AsciiBinary is either "A" or "B" */
FileSize = word( AfterName, 2 )     /* Size Of File In Bytes */
/*
*
*/
If  AsciiBinary = "A"
Then do
        /*
        ** OPEN THE ASCII FILE USING THE OS/2 EDITOR
        */
        MyAsciiViewer '"'FullPathName'"'
    End
Else do
    fext = right(FullPathName,4)
    if lastpos(".ZIP->",FullPathName) > 0
    Then Do
        fext = ".ZIP"
    End

    /*
    ** If The File Extension Has One Of The Popular Graphics
    ** Extension Use The Graphic Viewer To Look At The File
    */
    IsGraphic = (fext = ".BMP" ) | (fext = ".EPS" ) | (fext = ".GIF" ) |,
                (fext = ".IFF" ) | (fext = ".JPG" ) | (fext = ".MSP" ) |,
                (fext = ".PBM" ) | (fext = ".PCD" ) | (fext = ".PCX" ) |,
                (fext = ".PGM" ) | (fext = ".PIC" ) | (fext = ".PNG" ) |,
                (fext = ".PPM" ) | (fext = ".SHW" ) | (fext = ".TGA" ) |,
                (fext = ".TIF" )

    If IsGraphic
    Then Do
        /*
        ** OPEN THE GRAPHICS FILE USING A GRAPHICS VIEWER
        */
        MyGraphicViewer '"'FullPathName'"'
        End
    Else Do
        If fext = ".INF"
        Then Do
            /*
            ** View The INF File
            */
            MyInfViewer '"'FullPathName'"'
        End
        Else If fext = ".ZIP"
        Then Do
            /*
            ** View The .ZIP
            */
            z = lastpos(".ZIP",FullPathName)
            FullPathName = substr(FullPathName,1,z+3)
            MyZipViewer '"'FullPathName'" | more'
            pause
        End
        Else Do
            /*
            ** View The Binary File (As A Hex Dump)
            */
            say 'left(ext,6)'
            say 'left(ext,5)'
            MyBinaryViewer '"'FullPathName'"'
        End
    End
End


