//
// crc32 codes
//
#include <os2.h>
#include <stdio.h>
#include <time.h>
#include <string.h>

#include "crc32.h"


// crc 32 code
unsigned long crc32tab[256];
unsigned int  crc16tab[256];
unsigned int  crc16tabnew[256];



void crctabinit(void)
{
  int i,n;
  unsigned long CRC32;
  unsigned int  CRC16;
    for (i=0;i<256;i++)
        {
        CRC32=i;
        for (n=1;n<9;n++)
            {
            if (CRC32 & 1)
                CRC32 = (CRC32 >> 1) ^ /* XOR */ 0xedb88320;
            else
                CRC32 = CRC32 >> 1;
            }
        crc32tab[i] = CRC32;
        }


    for (i=0;i<256;i++)
            {
            CRC16=i;
            for (n=1;n<9;n++)
                {
                if (CRC16 & 1)
                    CRC16=(CRC16 >> 1) ^ 0xA001;
                else
                    CRC16=CRC16 >> 1;
                }
            crc16tab[i]=CRC16;
            }


    for (i=0;i<256;i++)
            {
            CRC16=i;
            for (n=1;n<9;n++)
                {
                if (CRC16 & 1)
                    CRC16=(CRC16 >> 1) ^ 0x8408;
                else
                    CRC16=CRC16 >> 1;
                }
            crc16tabnew[i]=CRC16;
            }


}

// CCITT CRC-32
unsigned long calc32crc(FILE *f)
{
 unsigned long CRC=0xffffffffL;
 unsigned int C;
 rewind(f);

 while((C=fgetc(f))!=EOF)
   CRC=crc32tab[(CRC ^ C) & 0xFF] ^ ((CRC>>8) & 0x00ffffffL);

 return CRC ^ 0xffffffffL;
}




unsigned int calc16crc(FILE *f,int mode)
// mode =0 CCITT CRC-16, AX.25 Europan
//       1 XModem/Zmodem/Arc/Hpack/LZH

{
 unsigned int  CRC=0xffff;
 unsigned int C;
 if (mode==1) CRC=0;

 rewind(f);

 while((C=fgetc(f))!=EOF)
    if (mode==1)
        CRC=((CRC >> 8) & 0x00ff) ^ crc16tab[(CRC ^ C) & 0x00ff];
    else
        CRC=((CRC >> 8) & 0x00ff) ^ crc16tabnew[(CRC ^ C) & 0x00ff];

 if (mode==1)
        return CRC;

 return CRC ^ 0xffff;
}



