/*This REXX script creates the ASCII file, SETUP0, and it also creates the*/
/*     ASCII file, SETUP.TXT. It places both files in the following directory:*/
/**/
/*	C:\Development\REXX\PROJECTS\Seek_Gold\LSB_Radix_Sort\Seek\SETUP\*/
/**/
/*The user of SEEK can use SETUP0 as a prototype file for constructing the*/
/*     SETUP file. SETUP provides user personalized setup setup information to SEEK.*/
/*     It is a required file. If SETUP is damaged or loss, use SETUP0 to reconstruct it.*/
/**/
/*The developer of SEEK can use SETUP.TXT to update the coding in the */
/*     CONSTRUCT_SETUP0 REXX method. This method is contained in the zDirectives*/
/*     file, which is located in the following directory:.*/
/**/
/*	C:\Development\REXX\PROJECTS\Seek_Gold\LSB_Radix_Sort\Seek\*/



/*Begin registering the REXXUtil Library, if not already registered*/
REXXUtilityFlag = RXFUNCQUERY("SYSLOADFUNCS")
IF REXXUtilityFlag \= 0 THEN DO
	CALL RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
	CALL SysLoadFuncs
END	/*Ends "IF REXXUtilityFlag \= 0 THEN DO" Section*/
/*End registering the REXXUtil Library, if not already registered*/



/*Begin variables to turn on and turn off red and green fonts at the commandline*/
Red_Text = "1B"x || "[1;31;40m"
Green_Text = "1B"x || "[1;32;40m"
Ansi_Off = "1B"x || "[0m"
/*End variables to turn on and turn off red and green fonts at the commandline*/



/*Begin finding the File Spec information on this program, SETUP.CMD, and assigning its value to the value, ProgramLocation, here in this program*/
BootDrive = SysBootDrive()
PARSE SOURCE OperatingSystem HowCalled FileSpec
ProgramLocation = ""
FileSpecPortion = FileSpec
DO UNTIL FileSpecPortion = ""
	PARSE Var FileSpecPortion FirstPart "\" SecondPart
	SELECT
		WHEN ProgramLocation = "" & SecondPart \= "" THEN ProgramLocation = FirstPart
		WHEN ProgramLocation \= "" & SecondPart \= "" THEN ProgramLocation = ProgramLocation"\"FirstPart
		OTHERWISE NOP
	END	/*Ends "SELECT" Section*/
	FileSpecPortion = SecondPart
END	/*Ends "DO UNTIL FileSpecPortion = """ Section*/
/*End finding the File Spec information on this program, SETUP.CMD, and assigning its value to the value, ProgramLocation, here in this program*/



/*Begin find the location of the SEEK VisProREXX program*/
PARSE VAR ProgramLocation SEEKLocation "\SETUP" Remainder
/*End find the location of the SEEK VisProREXX program*/


/*Begin the commandline user interface, explaining this REXX script and providing the choice to continue or exit*/
RC = SYSCLS
SAY ""
SAY "This REXX script creates the ASCII file, "Red_Text"SETUP0"Ansi_Off", and it also creates the"
SAY "     ASCII file, "Red_Text"SETUP.TXT"Ansi_Off". It places both files in the following directory:"
SAY ""
SAY "	"Green_Text||ProgramLocation"\"Ansi_Off
SAY ""
SAY "The user of "Green_Text"SEEK"Ansi_Off" can use "Red_Text"SETUP0"Ansi_Off" as a prototype file for constructing the"
SAY "     "Red_Text"SETUP"Ansi_Off" file. "Red_Text"SETUP"Ansi_Off" provides user personalized information to "Green_Text"SEEK"Ansi_Off"."
SAY "     It is a required file. If "Red_Text"SETUP"Ansi_Off" is damaged or loss, use "Red_Text"SETUP0"Ansi_Off" to"
SAY "     reconstruct it."
SAY ""
SAY "The developer of "Green_Text"SEEK"Ansi_Off" can use "Red_Text"SETUP.TXT"Ansi_Off" to update the coding in the"
SAY "     "Red_Text"CONSTRUCT_SETUP0"Ansi_Off" REXX method. This method is contained in the"
SAY "     "Green_Text"zDirectives"Ansi_Off" file, which is located in the following directory:"
SAY ""
SAY "	"Green_Text||SEEKLocation"\"Ansi_Off
SAY ""
SAY "	"Red_Text"1."Ansi_Off" Press "Red_Text"C"Ansi_Off" (or "Red_Text"c"Ansi_Off") to continue with the script."
SAY "	"Red_Text"2."Ansi_Off" Press the "Red_Text"ENTER"Ansi_Off" key to terminate."
SAY ""
SAY "Enter your choice now!"
PARSE UPPER PULL UserChoice
RC = SYSCLS
SELECT
	WHEN UserChoice = 1 | UserChoice = "C" THEN NOP
	OTHERWISE SIGNAL FINISHUP
END	/*Ends "SELECT" Section*/
/*Begin the commandline user interface, explaining this REXX script and providing the choice to continue or exit*/



/*Begin reading in the lines from the SETUP file and then writing (outputting) the SETUP0 and SETUP.TXT files*/
ReadFilePath = ProgramLocation"\SETUP"
WriteFilePath1 = ProgramLocation"\SETUP0"
WriteFilePath2 = ProgramLocation"\SETUP.TXT"
RC = .DTTOOLS~FIND_STREAM("SETUP", ProgramLocation, Red_Text, Green_Text, Ansi_Off)
IF RC = 1 THEN SIGNAL FINISHUP
Read_Lines. = .IO~READ_DATA(ReadFilePath)
Write_Lines1. = ""
Write_Lines1.[0] = Read_Lines.[0]
Write_Lines2. = ""
Write_Lines2.[1] = "::METHOD CONSTRUCT_SETUP0 CLASS"
Write_Lines2.[2] = "	USE ARG Location"
DO I = 1 TO Read_Lines.[0] BY 1
	Write_Lines1.[I] = Read_Lines.[I]
	J = I + 2
	Write_Lines2.[J] = "	Setup0_Line.["I"] = '"Read_Lines.[I]"'"
END I
J = J + 1
Write_Lines2.[J] = "	Setup0_Line.[0] = "Read_Lines.[0]
J = J + 1
Write_Lines2.[J] = "	RETURN O"
Write_Lines2.[0] = J
RC = .IO~WRITE_DATA(Write_Lines1., WriteFilePath1)
RC = .IO~WRITE_DATA(Write_Lines2., WriteFilePath2)
/*Begin reading in the lines from the SETUP file and then writing (outputting) the SETUP0 and SETUP.TXT files*/



/*Begin exiting this script*/
FINISHUP:
IF REXXUtilityFlag \= 0 THEN CALL SysDropFuncs
EXIT
/*End exiting this script*/


::CLASS DESKTOP
::CLASS DTTOOLS SUBCLASS DESKTOP
::METHOD STEM_INIT CLASS
	EXPOSE OutputStem.
	USE ARG InitializeValue
	OutputStem. = .STEM~NEW
	OutputStem. = InitializeValue
	RETURN OutputStem.

::METHOD FIND_STREAM CLASS
	USE ARG File, Location, Red_Text, Green_Text, Ansi_Off
	Flag = 0
	Path = Location"\"File
	StreamName = .STREAM~NEW(Path)
	RC = StreamName~QUERY("EXISTS")
	IF RC = .NIL | RC = "" THEN DO
		RC = SYSCLS
		SAY ""
		SAY ""
		SAY ""
		SAY ""
		SAY "Sorry, the ASCII file, "Red_Text||File||Ansi_Off", does not exist, or it does not reside"
		SAY "     in the following folder:"
		SAY ""
		SAY "	"Red_Text||Location"\"Ansi_Off
		SAY ""
		SAY "This file is necessary for the execution of this REXX script. The file and"
		SAY "     the script should be located in the same directory! Please fix this"
		SAY "     problem."
		SAY ""
		SAY "Press the "Red_Text"ENTER"Ansi_Off" key to terminate this script."
		PARSE UPPER PULL UserChoice
		RC = SYSCLS
		Flag = 1
	END	/*Ends "WHEN RC = .NIL | RC = "" THEN DO" Section*/
	RETURN Flag

::CLASS IO
::METHOD READ_DATA CLASS	/*Reads the lines in an ASCII file, supplied by the path information in the variable, ReadFile. Outputs that result to a stem variable, ReadFile_Lines.*/
	USE ARG ReadFile
	ReadFile_Lines. = .DTTOOLS~STEM_INIT("")
	I = 0
	DO WHILE LINES(ReadFile)
		I = I + 1
		ReadFile_Lines.I = LINEIN(ReadFile)
	END	/*Ends "DO WHILE LINES(ReadFile)" Section*/
	ReadFile_Lines.0 = I
	RC = LINEOUT(ReadFile)
	RETURN ReadFile_Lines.

::METHOD READ_DATA_1 CLASS	/*Reads the lines in an ASCII file, supplied by the path information in the variable, ReadFile. Removes any blank lines and outputs that result to a stem variable, ReadFile_Lines.*/
	USE ARG ReadFile
	ReadFile_Lines. = .DTTOOLS~STEM_INIT("")
	I = 0
	DO WHILE LINES(ReadFile)
		TestReadLine = LINEIN(ReadFile)
		IF TestReadLine \= "" THEN DO
			I = I + 1
			ReadFile_Lines.I = TestReadLine
		END	/*Ends "IF TestReadLine \= "" THEN DO" Section*/
	END	/*Ends "DO WHILE LINES(ReadFile)" Section*/
	ReadFile_Lines.0 = I
	RC = LINEOUT(ReadFile)
	RETURN ReadFile_Lines.

::METHOD READ_DATA_2 CLASS	/*Reads the lines in an ASCII file, supplied by the path information in the variable, ReadFile. Removes any lines that do not contain the desired "Needle1" or "Needle2" within the "Haystack" and outputs the result to a stem variable, ReadFile_Lines.*/
	USE ARG ReadFile, Needle1, Needle2
	ReadFile_Lines. = .DTTOOLS~STEM_INIT("")
	I = 0
	DO WHILE LINES(ReadFile)
		Haystack = LINEIN(ReadFile)
		IF POS(Needle1, Haystack) > 0 | POS(Needle2, Haystack) > 0 THEN DO
			I = I + 1
			ReadFile_Lines.I = Haystack
		END	/*Ends "IF POS(Needle1, Haystack) > 0 | POS(Needle2, Haystack) > 0 THEN DO" Section*/
	END	/*Ends "DO WHILE LINES(ReadFile)" Section*/
	ReadFile_Lines.0 = I
	RC = LINEOUT(ReadFile)
	RETURN ReadFile_Lines.

::METHOD WRITE_DATA CLASS	/*Writes the data, supplied by a stem variable, OutputStem., to a given file, supplied path information in the variable, WriteFilePath*/
	USE ARG OutputStem., WriteFilePath
	RC = SYSFILEDELETE(WriteFilePath)
	DO I = 1 TO OutputStem.[0] BY 1
		RC = LINEOUT(WriteFilePath, OutputStem.I)
	END I	/*Ends "DO I = 1 TO OutputStem.[0] BY 1" Section*/
	RC = LINEOUT(WriteFilePath)
	RETURN 0
