/* REXX installation script for Display Font Editor */
/* Copyright (C) 1998 by BigVic & Kolosoft Group */

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

/*-------------------------- Initialization ------------------------------*/
installdir = directory()

if GetYesNo( "Install Display Font Editor in "installdir ) == 0 then
   exit


/*------------------------- Create Display Font Editor folder ---------------------*/

param='ICONFILE='installdir'\finstfl.ICO;OBJECTID=<PMFOED_FLD>;ALWAYSSORT=Yes;ICONVIEWPOS=25,25,45,30'
rc = SysCreateObject( "WPFolder","Display Font Editor","<WP_DESKTOP>",param,"REPLACE" )
if rc then
   say "Display Font Editor folder successfully created on desktop..."
else
   say "ERROR: Display Font Editor folder creating failed!"

/*------------------- Create Display Font Editor object ---------------------------*/

param='ICONFILE='installdir'\pmfoed.ICO;OBJECTID=<PMFOED_EXE>;EXENAME='installdir'\pmfoed.EXE;STARTUPDIR='installdir
rc = SysCreateObject( "WPProgram", "Display Font Editor", "<PMFOED_FLD>",param,"REPLACE" )

if rc then
   say "Display Font Editor object successfully created..."
else 
   say "ERROR: Display Font Editor object creating failed!"


/*--------------- Create Display Font Editor Uninstall object -----------------------*/

param='ICONFILE='installdir'\funinst.ICO;EXENAME=*;PROGTYPE=PM;PARAMETERS=/C 'installdir'\funinst.CMD;STARTUPDIR='installdir
rc = SysCreateObject( "WPProgram", "Uninstall Display Font Editor", "<PMFOED_FLD>",param,'REPLACE')

if rc then
   say "Uninstall object successfully created..."
else 
   say "ERROR: Uninstall object creating failed!"


/*-------------------------- Install DC User Pack Information -----------------*/
param='PROGTYPE=PM;NOPRINT=YES;HELPPANEL=4083;EXENAME=VIEW.EXE;NOPRINT=YES;STARTUPDIR='installdir';PARAMETERS='installdir'\pmfoed.INF'
rc = SysCreateObject("WPProgram","Display Font Editor Reference","<PMFOED_FLD>",param,'REPLACE')

exit

GetYesNo: procedure

   ok = 0

   do until ok
      call charout, arg(1) || "? "
      pull reply
      reply = left(reply, 1)
      ok = (reply = "Y") | (reply = "N")
      if \ok then do
         say 'Sorry. Please enter "Y" or "N".'
      end
   end

return (reply = "Y")
