/* Script for save Phone Book from Phone, using OBEX */

Call RxFuncAdd 'SysSleep', 'RexxUtil', 'SysSleep'
Call RxFuncAdd 'SysGetKey', 'RexxUtil', 'SysGetKey'
Call RxFuncAdd 'SysCls', 'RexxUtil', 'SysCls'
Call RxFuncAdd 'SysTempFileName', 'RexxUtil', 'SysTempFileName'
Call RxFuncAdd 'SysFileDelete', 'RexxUtil', 'SysFileDelete'
Call RxFuncAdd 'RxAsyncRead', 'RXASYNC', 'RxAsyncRead'
Call RxFuncAdd 'RxAsyncWait', 'RXASYNC', 'RxAsyncWait'
Call RxFuncAdd 'RxAsyncSetMdmOutput', 'RXASYNC', 'RxAsyncSetMdmOutput'
Call RxFuncAdd 'RxAsyncGetRxCount', 'RXASYNC', 'RxAsyncGetRxCount'
call RxFuncAdd 'RxAsyncLoadFuncs', 'RXASYNC', 'RxAsyncLoadFuncs'
call RxAsyncLoadFuncs

signal on halt


/* [Global] */
comport="com1"
init="ATE0"
/* obexinit="AT+CPROT=0"  Try this if 1st not work */
obexinit="AT*EOBEX"
portspeed=115200
command_delay=0.5    /* delay between AT commands (sec) */
phonevol=7

/* [Internal] Don't modify w/o necessity !!! */
PortHandle=''
inpstr=''
remaining=''
debug=1
mainlog=1
crlf=d2c(13)d2c(10)
orgz=0

/* ------------- Entry Point -------------- */
Call SysCls

rc=crlf "    Automatic Ericsson Pbook Reader (OBEX) v 1.04 (c) By Alek Winner." crlf
say rc
if mainlog then call charout "pbook.log",rc

call comport_check


patrol:

parse arg pbook

if pbook="" then
  do
  say "Filename required..."
  exit
  end


rc = RxAsyncWrite( PortHandle, 0, init||crlf, 'Remaining' )
if rc <> 0 then signal err1
call check_string "Init", "OK", "  Modem not ready... Exitting... ;("


rc=" "date()"  " time() "  Phone Modem Initialized OK"
say rc
if mainlog then call lineout "pbook.log",rc


rc=" "date()"  " time() "  Sending "||obexinit||"..."
say rc
if mainlog then call lineout "pbook.log",rc


rc = RxAsyncWrite( PortHandle, 0, obexinit||crlf, 'Remaining' )
if rc <> 0 then signal err1
call check_string obexinit, "CONNECT", "  Requesting OBEX failed... Exitting... ;("


rc=" "date()"  " time() "  CONNECT Answered!"
say rc
if mainlog then call lineout "pbook.log",rc

call syssleep 0.5

rc=" "date()"  " time() "  Attempt to start OBEX Session..."
say rc
if mainlog then call lineout "pbook.log",rc

IRMC_str="80 00 13 10 00 40 00 46 00 0C 49 52 4D 43 2D 53 59 4E 43"
IRMC_str=x2c(IRMC_str)

rc = RxAsyncWrite( PortHandle, 0, IRMC_str, 'Remaining' )
if rc <> 0 then signal err1

plength=3
call byteread

if c2x(left(inpstr,1)) <> "A0" then
  do
  rc=" "date()"  " time() "  Connect Error! ErrCode is" c2x(inpstr)
  say rc
  if mainlog then call lineout "pbook.log",rc
  signal term
  end


plength=c2d(substr(inpstr,3,1))-3

rc=" "date()"  " time() "  OBEX Session started!"
say rc
if mainlog then call lineout "pbook.log",rc

rc=" "date()"  " time() "  Reading packet rest... ("||plength||"b)"
say rc
if mainlog then call lineout "pbook.log",rc

call byteread

rc=" "date()"  " time() "  Reading Done!"
say rc
if mainlog then call lineout "pbook.log",rc

file="telecom/devinfo.txt"
filename="devinfo.txt"
call get_object

file="telecom/rtc.txt"
filename="rtc.txt"
call get_object

file="telecom/cal/info.log"
filename="calinfo.log"
call get_object

file="telecom/cal.vcs"
filename="cal.vcs"
call get_object

/* Ericsson OBEX Developers's names .
file="telecom/calendar.txt"
filename="calendar.txt"
call get_object            
*/

file="telecom/pb/info.log"
filename="pbinfo.log"
call get_object

file="telecom/pb.vcf"
filename="pb.vcf"

call get_object     

pbook_end:

terminat:

rc=" "date()"  " time() "  Sending 81 00 03 (End Session)..."
say rc
if mainlog then call lineout "pbook.log",rc

string1=x2c("81 00 03")

call RxAsyncWrite PortHandle, 3, string1, 'Remaining'
flag=0

call check_string "Disconnect", "OK", "  Modem not ready... Exitting... ;("


rc=" "date()"  " time() "  Disconnected OK!"
say rc
if mainlog then call lineout "pbook.log",rc


call RxAsyncClose PortHandle
exit



/* --- Check Port State --------*/
comport_check:
if stream(comport,'c','open') = 'NOTREADY:32' then signal err0

call stream comport,'c','close'
rc = RxAsyncOpen( Comport, 'PortHandle' )

com_init:

rc = RxAsyncSetLnCtrl( PortHandle, portspeed, 8, 'N', 1 )
if rc <> 0 then signal err0

rc=RxAsyncSetDcbInfo(PortHandle,400,50,'00001001','10000000','','','','','' )
return

err0:
rc=" "date()"  " time() "  Comport is not respond... ;(" crlf
say rc
if mainlog then call charout "pbook.log",rc
/* call beep 262,250 */
exit
/* -----------------------------*/



/* -- Check Modem String --------- */
check_string:
PARSE ARG deb_str, ok_str, err_str

InpStr = ""
do until InpStr=ok_str||crlf | InpStr='ERROR'||crlf
rc = RxAsyncRead( PortHandle, 0, 3000, 'InpStr' )
if rc <> 0 then signal err1
db=deb_str InpStr crlf
if debug then call charout "debug.log",db
end

if InpStr = ok_str||crlf then return

err1:
rc=" "date()"  " time() err_str crlf
say rc
if mainlog then call charout "pbook.log",rc
/* call beep 262,250 */
signal term
/* -- Check Modem String - Ends -- */


/* ---- Check Byte Reading ---- */
byteread:
inp=''
cycle1:
if plength > 255 then
  do
  p=plength-255
  plength=255
  end
else p=0

rc = RxAsyncRead( PortHandle, plength, 10000, 'Inpstr' )
if rc=-1 then 
  do
  rc=" "date()"  " time() "  Phone Answer Timed Out!"
  say rc
  if mainlog then call lineout "pbook.log",rc
  signal terminat
  end

if p>0 then
  do
  inp=inp||inpstr
  plength=p
  signal cycle1
  end

inpstr=inp||inpstr

return
/* ---- Check Byte Reading Ends ---- */


/* ---- Get OBEX Object ---- */
get_object:

rc=" "date()"  " time() "  Requesting /"||file||"..."
say rc
if mainlog then call lineout "pbook.log",rc

fln=length(file)
flength=d2x(fln*2+5)
plength=d2x(fln*2+8)

do i=1 to fln*2 by 2
file=insert(x2c("00"),file,i)
end

packet=x2c("83 00"||plength||"01 00"||flength)||x2c(0)||file||x2c(0)

call RxAsyncWrite PortHandle, length(packet), packet, 'Remaining'


call SysFileDelete(filename)

i=0
frame=""
do forever
plength=3
call byteread

resp=c2x(left(inpstr,1))
select
when resp='A0' then endflag=1
when resp='90' then NOP
otherwise
  do
  rc=" "date()"  " time() "  Connect Error! ErrCode is" c2x(inpstr)
  say rc
  if mainlog then call lineout "pbook.log",rc
  signal terminat
  end
end

plength=x2d(c2x(substr(inpstr,2)))-3
call byteread

inpstr=substr(inpstr,4)
rc=" "date()"  " time() "  Answered Info about Object!"
say rc
if mainlog then call lineout "pbook.log",rc

call charout filename,inpstr

if filename="pbinfo.log" then
  do
  if pos("Total-Records:",inpstr)>0 then parse value inpstr with "Total-Records:" trec .
  if pos(crlf,trec)>0 then trec=left(trec,pos(crlf,trec)-1)

  parse value inpstr with "Maximum-Records:" maxrec .
  if pos(crlf,maxrec)>0 then maxrec=left(maxrec,pos(crlf,maxrec)-1)

  say "trec=" trec
  say "maxrec=" maxrec
  end

if filename="pb.vcf" then
  do
  parse value inpstr with "END:" vend
   if left(vend,5)<>"VCARD" then frame=frame||inpstr
   else
   do
   frame=frame||inpstr
   call clearbook 
   end
  end

if filename="cal.vcs" then
  do
  parse value inpstr with "END:V" vend
  sig="V"||left(vend,4)
  frame=frame||inpstr
  if sig ="VEVEN" | sig ="VTODO" then call clearcalbook
  end

if endflag=1 then signal m_next

rc=" "date()"  " time() "  Requesting Continue (83 00 03)..."
say rc
if mainlog then call lineout "pbook.log",rc
string1=x2c("83 00 03")
call RxAsyncWrite PortHandle, 3, string1, 'Remaining'

end

m_next:
call charout filename
endflag=0
return
/* ---- Get OBEX Object Ends ---- */

/* ---- Clear PhoneBook ---- */
clearbook:
   do while pos("END:VCARD", frame) > 0
   rc=pos("END:VCARD", frame)
   frm = substr(frame,1,rc+8)
   frame = substr(frame,rc+11)

   parse value frm with "VERSION:" . "N" name
   if left(name,1)=":" then
     do
     parse value name with ':' name ';' fname     
     end
   if left(name,1)=";" then
     if pos('FN;',frm)>0 then
       do
       parse value name with ';' name
       parse value frm with 'FN;' fname
       end
     else parse value name with ';' name ';' fname

   if pos(crlf,name)>0 then name=left(name,pos(crlf,name)-1)
   if pos(crlf,fname)>0 then fname=left(fname,pos(crlf,fname)-1)

/* say "N=" name "FN=" fname "=FN" */

   tel.0=0
   phone='PHONE'
   do while phone <> ''
   parse value frm with "TEL" pphone
   dtpoz=pos(':',pphone)
   if left(pphone,1)=";" then ptype=substr(pphone,2,dtpoz-2)
   else ptype='Other'

   phone=substr(pphone,dtpoz+1)
   if phone <> '' then
   do
   if pos(crlf,phone)>0 then phone=left(phone,pos(crlf,phone)-1)
/*   say "PT=" ptype "PP=" phone  */
   tel.0=tel.0+1
   t=tel.0
   tel.t=phone
   teltype.t=ptype
   end

   frm=pphone
   end

   pz=pos("=",name)
   if pz > 0 then
     do
     codename=name
     call quoted_unp
     name=coden
     end
   else parse value sum with ":" sum

   pz=pos("=",fname)
   if pz > 0 then
     do
     codename=fname
     call quoted_unp
     fname=coden
     end
   else parse value sum with ":" sum


call charout pbook||'.pbk', left(fname,30) left(name,30)
do t=1 to tel.0
call charout pbook||'.pbk', left(teltype.t,20) left(tel.t,30)
end
call charout pbook||'.pbk',crlf

i=i+1
if i > trec then signal pbook_end
rc=" "date()"  " time() "  Receiving" i "record from" trec
say rc
if mainlog then call lineout "pbook.log",rc

end

return
/* ---- Clear PhoneBook Ends ---- */


/* ---- Clear CalendBook ---- */
clearcalbook:

   do while pos("END:"||sig, frame) > 0
   rc=pos("END:"||sig, frame)

   if sig='VEVEN' then koef=1
   if sig='VTODO' then koef=0

   frm = substr(frame,1,rc+8+koef)
   frame = substr(frame,rc+11+koef)

if pos("DTSTART:",frm) > 0 then
  do
  parse value frm with "DTSTART:" dstart
  dstart=left(dstart,pos(crlf,dstart)-1)
  dstart=left(dstart,4)"/"substr(dstart,5,2)"/"substr(dstart,7,2) substr(dstart,10,2)":"substr(dstart,12,2)"-"substr(dstart,14,2) crlf
  end
else dstart='--'||crlf

if pos("DTEND:",frm) > 0 then
  do
  parse value frm with "DTEND:" dend
  dend=left(dend,pos(crlf,dend)-1)
  dend=left(dend,4)"/"substr(dend,5,2)"/"substr(dend,7,2) substr(dend,10,2)":"substr(dend,12,2)"-"substr(dend,14,2) crlf
  end
else dend='--'||crlf

if pos("CATEGORIES:",frm) > 0 then
  do
  parse value frm with "CATEGORIES:" cat
  cat=left(cat,pos(crlf,cat)-1)||crlf
  end

if pos("SUMMARY:",frm) > 0 then
  do
  parse value frm with "SUMMARY:" sum
  sum=left(sum,pos(crlf,sum)-1)
  end
else sum="N/A"

if pos("LOCATION:",frm) > 0 then
  do
  parse value frm with "LOCATION:" loc
  loc=left(loc,pos(crlf,loc)-1)
  end
else loc="N/A"

if pos("DESCRIPTION",frm) > 0 then
  do
  parse value frm with "DESCRIPTION:" desc
  desc=left(desc,pos(crlf,desc)-1)
  end
else desc="N/A"

if pos("AALARM:",frm) > 0 then
  do
  parse value frm with "AALARM:" aalarm
  aalarm=left(aalarm,pos(crlf,aalarm)-1)
  end
else aalarm="N/A"


   pz=pos("=",sum)
   if pz > 0 then
     do
     codename=sum
     call quoted_unp
     sum=coden
     end

   pz=pos(":",sum)   
   if pz > 0 then parse value sum with ":" sum


   pz=pos("=",loc)
   if pz > 0 then
     do
     codename=loc
     call quoted_unp
     loc=coden
     end

   pz=pos(":",sum)
   if pz > 0 then parse value loc with "CHARSET=ISO-8859-1:" loc



if aalarm = "N/A" then aalarm=aalarm||crlf
else
aalarm=left(aalarm,4)"/"substr(aalarm,5,2)"/"substr(aalarm,7,2) substr(aalarm,10,2)":"substr(aalarm,12,2)"-"substr(aalarm,14,2) crlf

orgz=orgz+1
message="Event:" orgz cat "Started at" dstart "Ended   at" dend "Alarmed at" aalarm "Caption" sum ",Location" loc ",Description" desc
say message
call lineout pbook||'.cal',message
call lineout pbook||'.cal'
end

return

/* ---- Clear CalendBook Ends ---- */


/* Quoted text & UTF-8 unpacker */
quoted_unp:

parse value codename with ":" codename

x=1
coden=''
cl=length(codename)
do while x<= cl
k=substr(codename,x,1)
if k='=' then
 do
 hseq=substr(codename,x+1,2)
 mseq=substr(codename,x+4,2)
 if hseq='D0' & mseq=81 then mseq=100

 if hseq="D0" then mseq=d2c(x2d(mseq)-16)
 if hseq="D1" then mseq=d2c(x2d(mseq)+96)


  if hseq <> "D0" & hseq <> "D1" then
   do
   k=''
   x=x+1
   iterate
   end 

 coden=coden||mseq
 x=x+6
 end
else
 do
 if c2d(k)=13 | c2d(k)=10 then k=''
 coden=coden||k
 x=x+1
 end
end

return

/* Quoted text & UTF-8 unpacker Ends */


/* ----- Close All Files -------*/
close_all:
call stream "pbook.log",'c','close'
call stream "debug.log",'c','close'
return
/* -----------------------------*/

term:
