/*** Psion REXX Interface API Usage Example ******/
/*** (c) 2001 Mike Potapoff                 ******/

/*** Function Return Code Definitions ************/
RET_OK              = 0
RET_NOT_CONNECTED   = -1
RET_ALREADY_RUNNED  = -2
RET_RUN_TIMEOUT     = -3
RET_NO_SUCH_PROCESS = -4

SAY 'Psion REXX Interface v1.0. Usage Example'
SAY '(c) 2001 Mike Potapoff'
SAY
SAY 'Registering all Functions for further usage'

CALL RxFuncAdd 'psiRxInit', 'psiREXX', 'psiRxInit'
CALL psiRxInit

SAY 'Connecting to Psion, attached to COM1...'

IF psiRxConnect("COM1") \== RET_OK THEN DO
    SAY 'Err: Connection to Psion Failure.'
    SAY '     Check the Connection or Parameters.'
    CALL psiRxExit
    EXIT
END
SAY 'Ok'
SAY
SAY 'Getting Various Information from Psion'
SAY
SAY 'Version = ' psiRxGetVersion()
SAY 'Machine = ' psiRxGetMachine()
SAY

/*** Owner Info consists of some strings. Parse it ***/
own = psiRxGetOwner()
SAY "Owner's Info:"
DO i = 1 BY 1 WHILE LENGTH(STRIP(own)) \= 0
    PARSE VALUE own WITH s '0A'x own
    say 'Line' i '=' s
END

SAY
SAY 'Get Other Information'
rc = psiRxGetInfo('Info')
SAY 'Info Pieces = ' Info.0
SAY
DO i = 1 to Info.0 by 1
    INTERPRET 'j = Info.' || Info.i
    SAY Info.i " = " j
END

SAY
SAY 'Testing process control routines'
SAY
SAY 'Spreadsheet Run and Wait for PID...'
ps = psiRxProgStart("C:\Documents\Sheet",  0, "id")
SELECT
  WHEN ps = RET_OK THEN
    SAY 'Task is Run, its ID = ' id
  WHEN ps = RET_ALREADY_RUNNED THEN
    SAY 'Task is Already Run, its ID = ' id
  WHEN ps = RET_NO_SUCH_PROCESS THEN
    SAY 'Err: No such task'
  WHEN ps = RET_RUN_TIMEOUT THEN
    SAY "Err: Psion didn't return task's PID in reasonable time"
END

SAY
SAY "Testing if Task is Running by it's PID..."
IF psiRxProgRunning(id) == RET_OK THEN
    SAY 'Ok'
ELSE
    SAY 'Err: No Such Process'

SAY
SAY "Testing if Task is Running by it's Name..."
IF psiRxProgRunning("C:\Documents\Sheet") == RET_OK THEN
    SAY 'Ok'
ELSE
    SAY 'Err: No Such Process'

SAY
SAY "Getting Tasks and PIDs Lists..."
call psiRxProgList 'PIDList', 'taskList'
SAY 'Ok, Total Number of Processes Running:' PIDList.0
SAY
SAY  'Process List'
DO i = 1 to PIDList.0
    SAY PIDList.i taskList.i
END

SAY
SAY 'Terminating Task without wait...'
SAY 'Stop by Name: ' psiRxProgKill("C:\Documents\Sheet")
SAY 'Stop by ID:   ' psiRxProgKill(id)
SAY
SAY 'Testing if Task Still Runnung...'
SAY 'Running: ' psiRxProgRunning(id)
SAY
SAY 'Terminating Task and waiting...'
SAY 'Stop:    ' psiRxProgKill(id,1)
SAY 'Running: ' psiRxProgRunning(id)
SAY
SAY 'Testing completed. Exiting.'

CALL psiRxExit
EXIT

/*
    End of Example
*/
