/*
 * profile.c - access to profile data
 *
 *      read/save window's position, font from/to profile file
 */

#define INCL_PM
#include <os2.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "tablet.h"

/*
 * profileRead - read window's position from profile
 */

void    profileRead(HAB hab, PSWP pswp, PUCHAR pfnt, PULONG pclr)
{
    HINI    hini ;
    BOOL    stat ;
    SWP     swp  ;
    LONG    len  ;
    UCHAR   font[128] ;
    ULONG   clr[2]    ;

    TRACE("profileRead\n") ;
    
    if (ProfilePath[0] == '\0') {
        return ;
    }
    if ((hini = PrfOpenProfile(hab, ProfilePath)) == NULLHANDLE) {
        return ;
    }

    memset(&swp, 0, (len = sizeof(swp))) ;
    stat = PrfQueryProfileData(hini, ProgramName, "pos", (PVOID) &swp, &len) ;
    if (stat == TRUE) {
        if (swp.x != 0 || swp.y != 0) {
            pswp->x   = swp.x    ;
            pswp->y   = swp.y    ;
            pswp->fl |= SWP_MOVE ;
        }
        if (swp.cx != 0 || swp.cy != 0) {
            pswp->cx  = swp.cx   ;
            pswp->cy  = swp.cy   ;
            pswp->fl |= SWP_SIZE ;
        }
    }
    
    memset(font, 0, (len = sizeof(font))) ;
    stat = PrfQueryProfileData(hini, ProgramName, "fnt", (PVOID) font, &len) ;
    if (stat == TRUE) {
        strcpy(pfnt, font) ;
    }
    
    memset(clr, 0, (len = sizeof(clr))) ;
    stat = PrfQueryProfileData(hini, ProgramName, "clr", (PVOID) clr, &len) ;
    if (stat == TRUE) {
        memcpy(pclr, clr, sizeof(clr)) ;
    }
    
    PrfCloseProfile(hini) ;

#ifdef  DEBUG
    if (pswp->fl & SWP_MOVE) {
        printf("MOVE %d,%d ", pswp->x, pswp->y) ;
    }
    if (pswp->fl & SWP_SIZE) {
        printf("SIZE %d,%d ", pswp->cx, pswp->cy) ;
    }
    if (strlen(font) > 0) {
        printf("FONT <%s>", font) ;
    }
    if (pswp->fl != 0 || strlen(font) > 0) {
        printf("\n") ;
    }
#endif
}

/*
 * profileSave - save window's positions to profile
 */

void    profileSave(HAB hab, PSWP pswp, PUCHAR pfnt, PULONG pclr)
{
    HINI    hini ;
    LONG    len  ;
    UCHAR   font[128] ;
    ULONG   clr[2]    ;
    
    TRACE("profileSave\n") ;

    if (ProfilePath[0] == '\0') {
        return ;
    }
    if ((hini = PrfOpenProfile(hab, ProfilePath)) == NULLHANDLE) {
        return ;
    }

    len = sizeof(SWP) ;
    PrfWriteProfileData(hini, ProgramName, "pos", (PVOID) pswp, len) ;

    memset(font, 0, (len = sizeof(font))) ;
    strcpy(font, pfnt) ;
    PrfWriteProfileData(hini, ProgramName, "fnt", (PVOID) font, len) ;

    memset(clr, 0, (len = sizeof(clr))) ;
    memcpy(clr, pclr, sizeof(clr)) ;
    PrfWriteProfileData(hini, ProgramName, "clr", (PVOID) clr, len) ;

    PrfCloseProfile(hini) ;
#ifdef  DEBUG
    printf("SAVE POS %d,%d SIZ %d,%d FONT <%s>\n", 
                        pswp->x, pswp->y, pswp->cx, pswp->cy, font) ;
#endif
}
