; $Id: dos2ldr.asm,v 1.2 2001/08/09 14:51:36 root Exp $
;
; A dummy loader to launch the real boot sectors from within itself.
;
; Note: not tied to any makefile!

ldr:
		cli
		sub	bx, bx
		mov	ss, bx
		mov	sp, 7C00h
		sti
;
; Tell that we are the trapdoor code
; 
		mov	ah, 2		; Write below the hibernation blurb
		mov	bh, 0
		mov	dx, 200h
		int	10h
		mov	cx, 1		; Now do some graphics art
		mov	ax, 9B0h
		mov	bx, 10h
		call	padv_cursor
		mov	al, ' '
		call	padv_cursor
		mov	bx, 19h
		mov	al, 0B1h
		call	padv_cursor
		mov	al, 0DBh
		call	padv_cursor
		mov	bx, 7
		push	cs
		pop	ds
		mov	si, (offset logo-offset ldr)
		cld
		lodsb
pump_sym:	call	padv_cursor
		lodsb
		cmp	al, 0
		jnz	pump_sym
		mov	ah, 2		; Advance by one line
		mov	bh, 0
		mov	dx, 0300h
		int	10h
;
; Clear the dirty flag for C: FAT16 partitions -- NEW CODE 09/08/2001.
; This code is dirty by itself since it doesn't care about FAT partitions at
; other locations, but we do not want to get involved into traversing MBR once
; again.			
;
		sub	bx, bx
		mov	es, bx
		mov	ax, 201h
		mov	bx, 8000h	; Uninhabited area
		mov	cx, 1
		mov	dx, 180h	; 1/0/1 on first HDD
		int	13h
		jc	process_boot	; Drop this bad idea
		cmp	word ptr es:[81FEh], 0AA55h
		jne	process_boot	; Not a BPB
		cmp	byte ptr es:[8000h], 0FAh
		je	process_boot	; CLI is likely for an MBR, bail out
		cmp	word ptr es:[8036h], 4146h
		jne	process_boot	; Not a FAT partition
		cmp	word ptr es:[8024h], 180h
		jne	process_boot	; Must be ID 80h, dirty flag set
		dec	byte ptr es:[8025h]
		mov	ax, 301h
		int	13h
;
; Relocate and lauch the transferred boot sector
;
process_boot:	mov	si, (offset int_bootrec-offset ldr)	; 70:0000 + X
		mov	di, 7C00h
		mov	cx, 256
; 		sub	bx, bx
; 		mov	es, bx
		rep	movsw
		mov	ax, es		; reuse old ES -- 09/08/2001
		mov	cx, ax
		mov	dx, ax
		mov	si, ax
		mov	di, ax
		mov	bp, ax
		mov	ds, ax
		db	0EAh
		dw	7C00h
		dw	0

;
; Advance the cursor after displaying a character (int 10h is provided)
;
padv_cursor:	int	10h
adv_cursor:	pusha
		mov	ah, 3
		mov	bh, 0
		int	10h
		mov	ah, 2
		inc	dl
		int	10h
		popa
		retn
		
logo		db	" IBM OS/2 Trapdoor", 0
		
int_bootrec:
