/* $Id: hibpatch.c,v 1.6 2001/07/18 21:30:47 root Exp $ */

#include <stdio.h>
#include <stdlib.h>

#include "patchtkt.h"
#include "os2ldr.h"
#include "os2krnl.h"
#include "pmviop.h"

void main(int argc, char **argv)
{
 FILE *stream;
 int rc=1;

 printf("HIBPATCH v 1.21 on " __DATE__ ", " __TIME__ "\n\n");
 if(argc<3)
 {
  printf("Usage: %s <filename.ext> <patch type>\n"
         "\n"
         "Where: <filename.ext> is the name of file to patch\n"
         "       <patch type> is:\n"
         "             /KRNLFIX = fix hibernation problems in recent OS/2 v 4.0 kernels\n"
         "                        (XR_M006 and higher) and Aurora\n"
         "              /LDRFIX = fix OS2LDR to prevent MBR trashing when returning\n"
         "                        from hibernation on HPFS drives\n"
         "               /WARP3 = bring an OS/2 v 4.0 kernel to Warp 3 level\n"
         "              /PMVIOP = stub away nonexistent imports in PMVIOP.DLL\n"
         "                        (to use backlevel OS/2 v 4.0 kernels with newer\n"
         "                        Warp 3 DLLs)\n",
         argv[0]);
  exit(1);
 }
 stream=file_open(argv[1], "r+b");
 if(!stricmp(argv[2], "/KRNLFIX"))
  rc=patch_os2krnl_hib(stream);
 else if(!stricmp(argv[2], "/LDRFIX"))
 {
  rc=patch_os2ldr_zap(stream);
  if(rc)
  {
   printf("WARNING: the OS2LDR fix is a must-have if you're hibernating onto a\n"
          "         non-FAT partition. Otherwise, OS2LDR will damage the data in\n"
          "         partition table!\n");
  }
 }
 else if(!stricmp(argv[2], "/WARP3"))
  rc=patch_os2krnl_level(stream);
 else if(!stricmp(argv[2], "/PMVIOP"))
  rc=patch_pmviop_ordinal(stream);
 else if(!stricmp(argv[2], "/SHELLFIX"))
  printf("SHELL.COM is no longer serviced as of v 1.21\n");
 else
  printf("Invalid option: %s\n", argv[2]);
 fclose(stream);
 exit(rc);
}
