/* REXX */
/* ランダムにフォルダーの壁紙を設定する */
/* (C) Copyright 1997 kyo */

options 'ETMODE'; options 'EXMODE';
arg trgt wallpdir fext itype '@' tr
trace value tr;
if trgt = '' then
do
	exit
end
/* Load functions */
if RxFuncQuery('SysLoadFuncs') then call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

/* Target */
trgt = strip(trgt)
/* Default Wallpaper directory */
if wallpdir = '' then
do
	wallpdir = 'f:\os2\bitmap\'
end
/* Default file extention */
if fext = '' then
do
	fext = 'bmp'
end
/* Default image type */
if itype = '' then
do
	itype = 'N'
end

/* Get image file info */
numjpeg = SysFileTree(wallpdir||'*.'||fext, 'file', 'O')
if numjpeg <> 0 | file.0 = 0 then
do
	signal error
end
/* 乱数 */
r = random(1, file.0)
param = 'BACKGROUND='||file.r||','||itype
call SysSetObjectData trgt, param

/* Open target object */
rc = SysSetObjectData(trgt, 'OPEN=ICON')

/* Finish */
exit

error:
say 'Error !'
exit