   H              8         (   Rexx Algorithms         P   ^   Binary Search /*==================(Binary search)===================*/
/* :-D                                              1 */
/* Name.......: BiSearch                              */
/*                                                    */
/* Function...: Search a stem variable for a value    */
/* Call parm..: Search value                          */
/* Returns....: 0 if nothing found                    */
/*              index of the found value              */
/* Sample call: found_index = BiSearch(value)         */
/*              If found_index = 0 Then               */
/*                Say 'Value' value 'not found!'      */
/*              Else                                  */
/*                Say stem.found_index                */
/*                                                    */
/* Notes......: The elements to search for must be    */
/*              saved in the stem named so as the     */
/*              stem in this Procedure (in this case  */
/*              "STEM.")                              */
/*              stem.0 must contain the number of     */
/*              elements in stem.                     */
/*              The stem-variable must be in the      */
/*              sorted order                          */
/*                                                    */
/* Changes....: No                                    */
/*                                                    */
/*====================================================*/
BiSearch: Procedure Expose stem.

Parse Arg value             /* Search value            */

found  = 0                  /* Index of the found Item */
bottom = 1                  /* Index of the first Item */
top    = stem.0             /* Index of the last Item  */

Do While found = 0 & top >= bottom
  mean = (bottom + top) % 2
  If value = stem.mean Then
    found = mean
  Else If value < stem.mean Then
    top = mean - 1
  Else
    bottom = mean + 1
End /* Do While */

Return found

 
        ,  8  Bubble Sort /*===================(Bubble sort)====================*/
/* :-I                                              2 */
/* Name.......: BubSort                               */
/*                                                    */
/* Function...: Bubble Sort for a stem variable       */
/* Call parm..: No                                    */
/* Returns....: nothing (NULL string)                 */
/*                                                    */
/* Sample call: Call BubSort                          */
/*                                                    */
/* Notes......: The elements to sort for must be      */
/*              saved in the stem named so as the     */
/*              stem in this Procedure (in this case  */
/*              "STEM.")                              */
/*              stem.0 must contain the number of     */
/*              elements in stem.                     */
/*                                                    */
/* Changes....: No                                    */
/*                                                    */
/*====================================================*/
BubSort: Procedure Expose stem.

Do i = stem.0 To 1 By -1 Until flip_flop = 1
  flip_flop = 1
  Do j = 2 To i
    m = j - 1
    If stem.m > stem.j Then Do
      xchg   = stem.m
      stem.m = stem.j
      stem.j = xchg
      flip_flop = 0
    End /* If stem.m ... */
  End /* Do j = 2 ...    */
End /* Do i = stem.0 ... */

Return ''

           ww#  Insertion Sort /*=================(Insertion sort)===================*/
/* :-!                                              3 */
/* Name.......: InsSort                               */
/*                                                    */
/* Function...: Insertion Sort for a stem variable    */
/* Call parm..: No                                    */
/* Returns....: nothing (NULL string)                 */
/*                                                    */
/* Sample call: Call InsSort                          */
/*                                                    */
/* Notes......: The elements to sort for must be      */
/*              saved in the stem named so as the     */
/*              stem in this Procedure (in this case  */
/*              "STEM.")                              */
/*              stem.0 must contain the number of     */
/*              elements in stem.                     */
/*                                                    */
/* Changes....: No                                    */
/*                                                    */
/*====================================================*/
InsSort: Procedure Expose stem.

Do x = 2 To stem.0
  xchg = stem.x
  Do y = x - 1 By -1 To 1 While stem.y > xchg
    xchg   = stem.x
    stem.x = stem.y
    stem.y = xchg
    x = y
  End /* Do y = x... */
  stem.x = xchg
End /* Do x = 2 ...  */

Return ''

           [[  Quick Sort /*====================(Quick sort)====================*/
/* :-D                                              4 */
/* Name.......: QSort                                 */
/*                                                    */
/* Function...: Quick Sort for a stem variable        */
/* Call parm..: No                                    */
/* Returns....: Left-Right span                       */
/*                                                    */
/* Sample call: Call QSort                            */
/*                                                    */
/* Notes......: The elements to sort for must be      */
/*              saved in the stem named so as the     */
/*              stem in this Procedure (in this case  */
/*              "STEM.")                              */
/*              stem.0 must contain the number of     */
/*              elements in stem.                     */
/*                                                    */
/* Changes....: No                                    */
/*                                                    */
/*====================================================*/
QSort: Procedure Expose stem.

Arg left, right

If left  = '' Then left  = 1
If right = '' Then right = stem.0
If right > left Then Do
  i = left
  j = right
  k = (left+right)%2
  x = stem.k
  Do Until i > j
    Do While stem.i < x; i = i + 1; End
    Do While stem.j > x; j = j - 1; End
    If i <= j Then Do
      xchg = stem.i
      stem.i = stem.j
      stem.j = xchg
      i = i + 1
      j = j - 1
    End
  End
  y = QSort(left,j)
  y = QSort(i,right)
End

Return right - left

 b         0  '';  Shell Sort /*====================(Shell sort)=====================*/
/* :-)                                               5 */
/* Name.......: ShlSort                                */
/*                                                     */
/* Function...: Shell Sort for a stem variable         */
/* Call parm..: No                                     */
/* Returns....: nothing (NULL string)                  */
/*                                                     */
/* Sample call: Call ShlSort                           */
/*                                                     */
/* Notes......: The elements to sort for must be       */
/*              saved in the stem named so as the      */
/*              stem in this Procedure (in this case   */
/*              "STEM.")                               */
/*              stem.0 must contain the number of      */
/*              elements in stem.                      */
/*                                                     */
/* Changes....: No                                     */
/*                                                     */
/*=====================================================*/
ShlSort: Procedure Expose stem.

parts = 3        /* adjust to your necessities ( >1 ) */
Do n = 1 To parts
  incr = 2**n - 1
  Do j = incr + 1 To stem.0
    i = j - incr
    xchg = stem.j
    Do While xchg < stem.i & i > 0
      m = i + incr
      stem.m = stem.i
      i = i - incr
    End /* Do While xchg ... */
    m = i + incr
    stem.m = xchg
  End /* Do j = incr ... */
End /* Do n = 1 ... */

Return ''

 ^&        z      Square root evolution /*====================(Square root)====================*/
/* :-)                                               6 */
/* Name.......: SqrRoot                                */
/*                                                     */
/* Function...: Square root evolution for the call     */
/*              parameter                              */
/* Call parms.: Evolution number, precision            */
/* Returns....: Square root                            */
/*                                                     */
/* Syntax.....: sqrt = SqrRoot(number, [precision])    */
/*                                                     */
/* Notes......: precision is the highest possible      */
/*              error for the evaluation.              */
/*              Default Value is 0.00001               */
/*              You are responsible for the valid      */
/*              number value                           */
/*                                                     */
/* Changes....: No                                     */
/*                                                     */
/*=====================================================*/
SqrRoot: Procedure Expose stem.

Arg number, precision

If Datatype(number) \= 'NUM' Then Return -1
If precision <= 0 | precision > 1 Then precision = 0.00001

sqrt = 1
 
Do Until Abs(sqrt_old - sqrt) < precision
  sqrt_old = sqrt
  sqrt = (sqrt_old * sqrt_old + number) / (2 * sqrt_old)
End /* Do Until ... */

Return sqrt

 ),        v&  &  Play digital file /*================(Play digital file)================*/
/* :-)                                OS/2 Only!!! 7 */
/* Name.......: PlayFile                             */
/*                                                   */
/* Function...: Play digital WAV/MID file            */
/*                                                   */
/* Call parms.: File name to play                    */
/* Returns....: RC from the last mciRexx function    */
/*                                                   */
/* Sample call: rc = PlayFile('bach.mid')            */
/*                                                   */
/* Changes....: No                                   */
/*                                                   */
/*===================================================*/
PlayFile: Procedure

Arg CmdObject
If CmdObject = '' Then Return -1

loudness = 70 /* % */
/*--------------(Prepare MCI-commands)---------------*/
CmdStr.1 = 'OPEN' CmdObject 'ALIAS W WAIT'
CmdStr.2 = 'SET W TIME FORMAT MS WAIT'
CmdStr.3 = 'SET W AUDIO VOLUME' loudness 'WAIT'
CmdStr.4 = 'PLAY W WAIT'
/*------------(Play digital WAV/MID file)------------*/
Do i = 1 To 4
  /*-----------(Send MCI command strings)------------*/
  rc = mciRxSendString(CmdStr.i, 'retstrvar', '0','0')
  If rc > 0 Then Leave
End

CmdStr = 'CLOSE W WAIT'
/*--------------(Send MCI command string)--------------*/
rc = mciRxSendString(CmdStr, 'retstrvar', '0','0')

Return rc

 k0        A,  Y,  Translate To Lower Case /*=============(Translate To Lower Case)===============*/
/* :-)                                               8 */
/* Name.......: ToLower                                */
/*                                                     */
/* Function...: Translate entired string to lower      */
/*              case                                   */
/* Call parms.: String to translate                    */
/* Returns....: Translated string                      */
/*                                                     */
/* Syntax.....: lowString = ToLower(upperString)       */
/*                                                     */
/* Changes....: No                                     */
/*                                                     */
/*=====================================================*/
ToLower: Procedure

/*------------(Lower Case entired string)--------------*/
Parse Arg Upper_String

Lowers='abcdefghijklmnopqrstuvwxyz'
Uppers='ABCDEFGHIJKLMNOPQRSTUVWXYZ'

Return Translate(Upper_String, Lowers, Uppers)

 B6        0  0  Exclude multiple items  /*=============( Exclude multiple items )=============*/
/*                                                 11 */
/* Name.......: NoMult                                */
/*                                                    */
/* Function...: Excludes multiple lines from a sorted */
/*              file                                  */
/* Call parm..: nothing                               */
/* Returns....: nothing (0)                           */
/*                                                    */
/* Syntax.....: Call NoMult / y = NoMult()            */
/*                                                    */
/* Notes......: The elements to exclude must be       */
/*              saved in the stem named so as the     */
/*              stem in this Procedure (in this case  */
/*              "STEM.")                              */
/*              stem.0 must contain the number of     */
/*              elements in stem.                     */
/*              The stem variable must be previously  */
/*              sorted                                */
/*                                                    */
/* Changes....: No                                    */
/*                                                    */
/*====================================================*/
NoMult: Procedure Expose stem.

Do i = 1 To stem.0
  Queue stem.i
  Do j = i + 1 while stem.i = stem.j
  End
  i = j - 1
End

Return 0
 ;        Z6    s6  Gregorian to julian date /*=============(Gregorian to julian date)==============*/
/*                                                  9  */
/* Name.......: G2J                                    */
/*                                                     */
/* Function...: translates gregorian date to the       */
/*              julian date                            */
/* Call parm..: gregorian date in format yyyy.mm.dd    */
/* Returns....: julian date (yyyy.ddd)                 */
/*                                                     */
/* Syntax.....: julDate = G2J(yyyy.mm.dd)              */
/*                                                     */
/* Changes....: No                                     */
/*                                                     */
/*=====================================================*/
G2J: Procedure
Arg gregDat

year = SubStr(gregDat,1,4)
mon  = SubStr(gregDat,6,2) + 0 /* To delete leading zero */
day  = SubStr(gregDat,9,2)

mon.1  = 0
mon.2  = 31
mon.3  = 59
mon.4  = 90
mon.5  = 120
mon.6  = 151
mon.7  = 181
mon.8  = 212
mon.9  = 243
mon.10 = 273
mon.11 = 304
mon.12 = 334

If (year // 400 = 0 | (year // 100 > 0 & year // 4 = 0)) & mon > 2 Then
  leap = 1
Else leap = 0

julDay = mon.mon + day + leap

Return year'.'Right(julDay,3,'0')
 @        ;  --;  Julian to gregorian date /*========(Translate julian to gregorian date)========*/
/*                                                 10 */
/* Name.......: J2G                                   */
/*                                                    */
/* Function...: translates julian to gregorian date   */
/*              julian date                           */
/* Call parm..: julian date in format yyyy.ddd        */
/* Returns....: julian date (yyyy.mm.dd)              */
/*                                                    */
/* Syntax.....: gregDate = J2G(yyyy.gdd)              */
/*                                                    */
/* Changes....: No                                    */
/*                                                    */
/*====================================================*/
J2G: Procedure
Arg julDate

Parse Var julDate year'.'jday

mon.1  = 0
mon.2  = 31
mon.3  = 59
mon.4  = 90
mon.5  = 120
mon.6  = 151
mon.7  = 181
mon.8  = 212
mon.9  = 243
mon.10 = 273
mon.11 = 304
mon.12 = 334

If year // 400 = 0 | (year // 100 > 0 & year // 4 = 0) Then
  leap = 1
Else
  leap = 0

Do i = 1 To 12 
  If i > 2 Then mon.i = mon.i + leap
  If jday > mon.i Then mon = i
End

day = jday - mon.mon
gregDate = year'.'Right(mon,2,'0')'.'Right(day,2,'0')

return gregDate
         
 
 	A  A  Date 2000 /*=======(Translate year to year with century)========*/
/*                                                 11 */
/* Name.......: Date2000                              */
/*                                                    */
/* Function...: Translates year to year with century  */
/* Call option:   Returns dd Mmm yyyy                 */
/*              B Returns dddddd days since 01.01.0001*/
/*              D Returns ddd - days                  */
/*              E Returns dd/mm/yyyy                  */
/*              J Returns yyyy.ddd - julians date     */
/*              L Returns dd Month yyyy               */
/*              M Returns Month                       */
/*              N Returns dd Mmm yyyy                 */
/*              O Returns yyyy/mm/dd                  */
/*              S Returns yyyymmdd                    */
/*              U Returns mm/dd/yyyy                  */
/*              W Returns Weekday                     */
/*                                                    */
/* Syntax.....: Date = Date2000(Option)               */
/*                                                    */
/* Changes....: No                                    */
/*                                                    */
/*====================================================*/
Date2000: Procedure
Parse Value Arg(1) With Option +1 .

If Option = '' Then Return Date()
If Verify('EJOU', Option, 'M') > 0 Then Do
  Parse Value Date() With . . yyyy
  If Option = 'J' Then Return yyyy || '.' || Date('D')
  Else If Option = 'O' Then Do
    Parse Value Date(Option) With . +2 Rest
    Return yyyy || Rest
  End
  Else Do
    Parse Value Date(Option) With Rest +6 .
    Return Rest || yyyy
  End
End
Else Return Date(Option)
 