/* REXX **********************************************/
/*                                                   */
/* Program name: G2J                                 */
/* Function    : translates gregorian date to julian */
/*               date                                */
/* Syntax      : julDate = G2J(yyyy.mm.dd)           */
/* Changes     :                                     */
/*                                                   */
/* Author      : Janosch R. Kowalczyk                */
/*                                                   */
/* Made use of GREED.  09 Jul 1996 / 13:21:56   JRK  */
/*****************************************************/
Parse Arg gregDate

If gregDate = '' Then gregDate = '1954.06.16'

/*-------------(Exceptions handling )---------------*/
Signal On Failure Name CLEARUP
Signal On Halt Name    CLEARUP
Signal On Syntax Name  CLEARUP

If gregDate > '' Then Do

  gregDate = TestGreg(gregDate) 
  Say gregDate '--->' G2J(gregDate)
  Say '1900.01.01 --->' G2J('1900.01.01')
  Say '1900.02.28 --->' G2J('1900.02.28')
  Say '1900.03.01 --->' G2J('1900.03.01')
  Say '1900.12.31 --->' G2J('1900.12.31')
  Say '1996.01.01 --->' G2J('1996.01.01')
  Say '1996.02.28 --->' G2J('1996.02.28')
  Say '1996.03.01 --->' G2J('1996.03.01')
  Say '1996.12.31 --->' G2J('1996.12.31')
  Say '1997.01.01 --->' G2J('1997.01.01')
  Say '1997.02.28 --->' G2J('1997.02.28')
  Say '1997.03.01 --->' G2J('1997.03.01')
  Say '1997.12.31 --->' G2J('1997.12.31')
  Say '2000.01.01 --->' G2J('2000.01.01')
  Say '2000.02.28 --->' G2J('2000.02.28')
  Say '2000.03.01 --->' G2J('2000.03.01')
  Say '2000.12.31 --->' G2J('2000.12.31')

End
Else Call HelpText

/*-------------------(End program)------------------*/
Call CharOut , "Press enter to exit "
pull y

Exit

CLEARUP:
Say 'GREED001E - Break, Failure or Syntax Error'
Exit


/*================(Test plausibility)===============*/
TestGreg: Procedure
Arg gregDate

laenge = Length(gregDate)

If laenge = 8 Then Do
  gregDate = '19'||gregDate
End
Else If laenge \= 10 Then Do
  gregDate = Date( 'S' )
  gregDate = Insert( '.', gregDate, 6)
  gregDate = Insert( '.', gregDate, 4)
End

Return Translate(gregDate,'.', ' /')


/*=================(Translate date)=================*/
G2J: Procedure
/*--------------------------------------------------*/
/*                                                  */
/* Procedure name: G2J                              */
/* Function      : translates gregorian date to the */
/*                 julian date                      */
/* Syntax        : julDate = G2J(yyyy.mm.dd)        */
/* Changes       :                                  */
/*                                                  */
/* Author        : Janosch R. Kowalczyk             */
/*                                                  */
/* Made use of GREED.  09 Jul 1996 / 13:21:56   JRK */
/*--------------------------------------------------*/
Arg gregDate

year = SubStr(gregDate,1,4)
mon  = SubStr(gregDate,6,2) + 0
day  = SubStr(gregDate,9,2)

mon.1  = 0
mon.2  = 31
mon.3  = 59
mon.4  = 90
mon.5  = 120
mon.6  = 151
mon.7  = 181
mon.8  = 212
mon.9  = 243
mon.10 = 273
mon.11 = 304
mon.12 = 334

If (year // 400 = 0 | (year // 100 > 0 & year // 4 = 0)) & mon > 2 Then
  leap = 1
Else leap = 0

julDay = mon.mon + day + leap

Return year'.'Right(julDay,3,'0')


/*=================(Help texts)=================*/
HelpText: Procedure

Say 'Syntax:'                                             
Say                                                       
Say 'G2J gregorian_date'                                     
Say                                                       
Say 'gregorian_date has format: yyyy.mm.dd'    
Say '                       or: yyyy/mm/dd'                                                          
Say '                       or: yyyy mm dd'                                                          

Return                                                    
