/*
	unlfpak.c
	do[W
	
	by sava/LP-Project, 1999.
*/

#include <ctype.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "filemtch.h"

typedef unsigned char	byte;
typedef unsigned short	word;
typedef unsigned long	dword;

typedef struct PAKHDR {
	char	name[12];
	dword	top;
	dword	length;
	dword	next;
} PAKHDR, *PPAKHDR;

#define NUMOFMASK		4
#define COUNT_OF_MASK	11

static byte		mask[NUMOFMASK][12] = {
	"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", \
	"\x71\x48\x6a\x55\x9f\x13\x58\xf7\xd1\x7c\x3e\x00",	/* , */ \
	"\xd1\x58\x6a\x56\x9a\x13\xa5\xf7\x7c\x3e\x74\x00",	/* To Heart */ \
	"\x51\x42\xfe\x77\x2d\x65\x48\x7e\x0a\x8a\xe5\x00"	/* VN */ };


unsigned int
unmask_pak(
	void * mem, /* */
	unsigned int bytes, /* */
	unsigned int mask_loc, /* */
	int pak_type
)
{
	if (mask_loc >= COUNT_OF_MASK) mask_loc %= COUNT_OF_MASK;
	
	while(bytes--) {
		*(byte *)mem -= mask[pak_type][mask_loc];
		mem = (void *)((byte *)mem + 1);
		mask_loc++;
		if (mask_loc >= COUNT_OF_MASK) mask_loc = 0;
	}

	return mask_loc;
}


int
validate_pakheader(
	void * hdrs, 		/* */
	int num_of_hdrs		/* */
)
{
	int			result = NUMOFMASK;
	PAKHDR		h;
	dword		t, s, n;
	
	while(--result) {
		memcpy(&h, hdrs, sizeof(h));
		unmask_pak(&h, sizeof(h), 0, result);
		t = h.top;
		s = h.length;
		n = h.next;
		
		/*
		printf("%s\n", h.name);
		printf("t %08lx  s %08lx  n %08lx\n",t ,s ,n);
		*/
		
		if ((t + s) == n) break;
	}
	
	return result;
}



typedef struct pak_info {
	int			pak_type;
	int			cnt_hdrs;
	PPAKHDR		hdrs;
} pak_info;


int
is_match(const char *s, int argc, char **argv)
{
	int		result;
	char	*defargv[] = { "*", "" };

	if (argc == 0) { argc = 1; argv = defargv; }
	
	while(argc--) {
		result = file_match(s, *argv, 0);
		if (result) break;
		argv++;
	}
	
	return result;
}


int
load_pak_info(pak_info *pak, FILE * fi)
{
	byte		s[10];
	long		len;
	int			cb_hdrs;
	
	pak->hdrs = NULL;
	pak->pak_type = 0;
	memset(s, 0, sizeof(s));
	
	fseek(fi, 0L, SEEK_SET);
	fread(s, sizeof(s), 1, fi);
	pak->cnt_hdrs = ((word)(s[9]) << 8) | s[8];
	
	cb_hdrs = pak->cnt_hdrs * sizeof(PAKHDR);
	
	fseek(fi, 0L, SEEK_END);
	len = ftell(fi);
	if (memcmp(s, "LEAFPACK", 8) != 0 || len < 10L + cb_hdrs) {
		fprintf(stderr, "Not LEAFPACK (or broken)\n");
		return 1;
	}
	fseek(fi, len - (long)cb_hdrs, SEEK_SET);
	if ((pak->hdrs = (PPAKHDR)malloc(cb_hdrs)) == NULL) {
		fprintf(stderr, "Memory not enough.\n");
		return 1;
	}
	
	if (fread(pak->hdrs, cb_hdrs, 1, fi) == 0) {
		fprintf(stderr, "Load error.\n");
		free(pak->hdrs); pak->hdrs = NULL;
		return 1;
	}
	
	pak->pak_type = validate_pakheader(pak->hdrs, pak->cnt_hdrs);
	if (pak->pak_type == 0) {
		fprintf(stderr, "Unknown LEAFPACK.\n");
		free(pak->hdrs); pak->hdrs = NULL;
		return 1;
	}
	
	unmask_pak(pak->hdrs, cb_hdrs, 0, pak->pak_type);
	
	return 0;
}


void
unload_pak_info(pak_info * pak)
{
	if (pak->hdrs) { free(pak->hdrs); pak->hdrs = NULL; }
}


void
delim83(char *d, const char *s)
{
	int		i;
	char	*dd;
	
	dd = d;
	for(i=0; i<8; i++) {
		*dd = s[i];
		if (s[i] == ' ') { break; }
		dd++;
	}
	*dd++ = '.';
	for(i=8; i<11; i++) {
		*dd = s[i];
		if (s[i] == ' ') { break; }
		dd++;
	}
	*dd = '\0';
}


int
listPak(FILE *fi, int argc, char **argv)
{
	int			result;
	pak_info	pak;
	PPAKHDR		hdr;
	int			disp;
	int			i;
	char		d[16];
	
	result = load_pak_info(&pak, fi);
	disp = 0;
	hdr = pak.hdrs;
	if (result == 0) for(i=0; i<pak.cnt_hdrs; i++) {
		delim83(d, hdr->name);
		if (is_match(d, argc, argv)) {
			printf("%-12s  %ld bytes\n", d, hdr->length);
			disp++;
		}
		hdr++;
	}
	printf("------------\n %d of %d file(s)\n", disp, pak.cnt_hdrs);
	unload_pak_info(&pak);
	return result;
}


int
extractPak(FILE *fi, int argc, char **argv)
{
	int			result;
	pak_info	pak;
	PPAKHDR		hdr;
	int			extract, errf;
	int			i;
	char		d[16];
	FILE		*fo;
	void 		*buf;
	
	result = load_pak_info(&pak, fi);
	extract = 0;
	errf = 0;
	hdr = pak.hdrs;
	if (result == 0) for(i=0; i<pak.cnt_hdrs; i++) {
		delim83(d, hdr->name);
		if (is_match(d, argc, argv)) {
			printf("%-12s  %ld bytes...", d, hdr->length);
			buf = malloc(hdr->length);
			if (buf == NULL) {
				fprintf(stderr, "Memory not enough.\n");
				result = 1;
			}
			else {
				int stat;
				fseek(fi, hdr->top, SEEK_SET);
				stat = fread(buf, hdr->length, 1, fi);
				if (stat == 0) {
					fprintf(stderr, "Read err.\n");
					result = 1;
				}
				else {
					unmask_pak(buf, hdr->length, 0, pak.pak_type);
					fo = fopen(d, "wb");
					if (!fo) {
						fprintf(stderr, "can't create\n");
						result = 1;
					} else {
						if (fwrite(buf, hdr->length, 1, fo) == 0) {
							fprintf(stderr, "Write err\n");
							result = 1;
						}
					}
					if (fo) fclose(fo);
				}
			}
			if (buf) free(buf);
			if (result == 0) { puts("OK!"); extract++; }
			else errf++;
		}
		hdr++;
	}
	
	printf("------------\n%d of %d file(s)\n", extract + errf, pak.cnt_hdrs);
	if (errf) printf("%d error(s)", errf);
	else printf("No error");
	printf(" occured.\n");
	
	unload_pak_info(&pak);
	return result;
}

void
usage(void)
{
	const char  msg[] = \
		"unlfpak [l|e] pakfile [files...]\n"
		"   l    list file(s)\n"
		"   e    extract file(s) to current dir\n"
		"pakfile LEAFPACK archive\n"
		" files  file(s) to extract\n"
		"        (wild card characters * and ? are available to use)\n"
		"";
	
	puts(msg);
}

int
main(int argc, char **argv)
{
	int		result = 1;
	FILE	*fi;
	char	c;
	
	if (argc <= 2) { usage(); return -1; }
	
	c = argv[1][0];
	if (c == '-' || c == '/') c = argv[1][1];
	c = toupper(c);
	if (c != 'L' && c != 'E') { usage(); return -1; }
	
	fi = fopen(argv[2], "rb");
	if (fi) {
		if (c == 'L') result = listPak(fi, argc - 3, argv + 3);
		if (c == 'E') result = extractPak(fi, argc - 3, argv + 3);
		fclose(fi);
	} else {
		fprintf(stderr, "Can't open %s.\n", argv[2]);
	}
	return result;
}
