/*
	ilfg2.h
*/

#ifndef _WATER_ILFG2_H__
#define _WATER_ILFG2_H__

#define IDSTR_LF2		"LEAF256"
#define IDSTR_LFG		"LEAFCODE"

#if !defined(RC_INVOKED)

#pragma pack(1)

typedef struct LF2PAL {
	BYTE	b;
	BYTE	g;
	BYTE	r;
} LF2PAL, * PLF2PAL;

typedef struct LFGHDR {
	char		id[8];					/* Ԃ ID "LEAFPACK" */
	BYTE		paldata[24];			/* Ԃpbg 4bits x 3 x 16 */
	USHORT		x0;						/* Ԃ (x1-x0+1) *8 = hbg */
	USHORT		y0;
	USHORT		x1;						/* Ԃ (y1-y0+1) = chbg */
	USHORT		y1;
	BYTE		scan_mode;				/* Ԃ 0...cXL 1... */
	BYTE		color_transparent;		/* Ԃ񓧖F (ff...Ȃ) */
	BYTE		unknown[2];				/* Ȃ */
	ULONG		bitmap_size;			/* ԂWJ̉摜TCY */
} LFGHDR, *PLFGHDR;

typedef struct LF2HDR {
	char		id[8];					/* Ԃ ID "LEAF256\0" */
	USHORT		unknown_08;				/* Ȃ */
	USHORT		unknown_0a;				/* Ȃ */
	USHORT		width;					/* Ԃ񉡃hbg */
	USHORT		height;					/* Ԃchbg */
	USHORT		data_pos;				/* Ԃ摜f[^̃ItZbg */
	USHORT		color_transparent;		/* Ԃ񓧖F̃pbgԍ */
	USHORT		unknown_14;				/* Ȃ */
	USHORT		num_of_palettes;		/* Ԃpbg */
	LF2PAL		pal[1];					/* Ԃ񂱂pbg */
} LF2HDR, * PLF2HDR;

#pragma pack()

#endif

/*
---------------------------------------
	uv
---------------------------------------
*/

#ifndef IDD_ABOUT
#define IDD_ABOUT			100
#endif
#ifdef IDD_LOADSETTING
#define IDD_LOADSETTING		200
#endif
#ifdef IDD_SAVESETTING
#define IDD_SAVESETTING		300
#endif


#if !defined(RC_INVOKED)

typedef BITMAPINFOMATION	BITMAPINFORMATION, * PBITMAPINFORMATION;

#ifdef __cplusplus
extern "C" {
#endif

BOOL  EXPENTRY INITWATERPLUGIN2( WATER * );
BOOL  EXPENTRY WATERPLUGINLOADCHECK2( WATER * );
BOOL  EXPENTRY WATERPLUGINLOAD2( WATER * );
BOOL  EXPENTRY WATERPLUGINSAVECHECK2( WATER * );
BOOL  EXPENTRY WATERPLUGINSAVE2( WATER * );

#if 0
MRESULT  EXPENTRY WATERPLUGINABOUT2( HWND, ULONG, MPARAM, MPARAM);
MRESULT  EXPENTRY WATERPLUGINLOADSETTING2( HWND, ULONG, MPARAM, MPARAM);
MRESULT  EXPENTRY WATERPLUGINSAVESETTING2( HWND, ULONG, MPARAM, MPARAM);
#endif

#ifdef __cplusplus
}
#endif

#endif /* !defined(RC_INVOKED) */


#define COPYRIGHT	\
	"Leaf 16/256colors LFG/LF2 Plugin ver 0.02\n" \
	"by sava/LP-Project, 1999."

#define FILEEXT \
	"*.LFG\tLeaf LFG 16colors (*.LFG) \n*.LF2\tLeaf LF2 256colors (*.LF2) \n"


#endif /* _WATER_ILFG2_H_ */
