/* Wacom Bamboo stylus events to xsmouse.sys */
rc=RxFuncAdd('SysGetMessage','RexxUtil','SysGetMessage')
rc=RxFuncAdd('SysSleep','RexxUtil','SysSleep')

/* set log file name */
ddNameR='astylus.log'

/* report astylus.cmd started */
info='<============<astylus.cmd> started on <'||date()||'> at <'||time()'>============>'
rc=lineout(ddNameR,info) ; say info

/* set device driver names */
ddNameI='$BAMBOO$' ; ddNameO='XSMOUSE$'

/* verify that the direct control driver exists in config.sys */
if stream(ddNameI,'command','query exists') \= '\DEV\' || ddNameI
then do
  info='DEVICE=?:\OS2\BOOT\USBECD.SYS required in CONFIG.SYS'
  rc=lineout(ddNameR,info) ; say info
  /* wait */
  '@pause'
  exit
  end

/* acquire the direct control driver */
rc=stream(ddNameI,'command','open write')
if rc \= 'READY:'
then do
  info=rc||' Device driver '||ddNameI||' currently in use. Please try later.'
  rc=lineout(ddNameR,info) ; say info
  /* wait */
  '@pause'
  exit
  end

/* set configuration - configured */
rc=charout(ddNameI,x2c(00 09 01 00 00 00 00 00))
rc=stream(ddNameI,'description')
if rc \= 'READY:'
then do
  /* obtain and issue error message */
  parse value rc with sState ':' mNumber
  say SysGetMessage(mNumber,,ddNameI)
  say 'set configuration failed!'
  /* wait */
  '@pause'
  exit
  end

/* set report - feature */
rc=charout(ddNameI,x2c(21 09 02 03 00 00 02 00 02 02))
rc=stream(ddNameI,'description')
if rc \= 'READY:'
then do
  /* obtain and issue error message */
  parse value rc with sState ':' mNumber
  say SysGetMessage(mNumber,,ddNameI)
  say 'set feature report failed!'
  /* wait */
  '@pause'
  exit
  end

/* wait 30 milliseconds */
call SysSleep(0.030)

/* verify that the emulate mouse driver exists in config.sys */
if stream(ddNameO,'command','query exists') \= '\DEV\' || ddNameO
then do
  info='DEVICE=?:\OS2\BOOT\XSMOUSE.SYS required in CONFIG.SYS'
  rc=lineout(ddNameR,info) ; say info
  /* wait */
  '@pause'
  exit
  end

/* acquire the emulate mouse driver */
rc=stream(ddNameO,'command','open')
if rc \= 'READY:'
then do
  info=rc||' Device driver '||ddNameO||' currently in use. Please try later.'
  rc=lineout(ddNameR,info) ; say info
  /* wait */
  '@pause'
  exit
  end

/* set digitizer size */
xdmm=147.20 ; /* millimeter */
ydmm=092.00 ; /* millimeter */

/* convert digitizer size */
xdmi=(xdmm*10000)/254 ; /* mInch */
ydmi=(ydmm*10000)/254 ; /* mInch */

/* set digitizer resolution */
xppi=2540 ; /* points/inch */
yppi=2540 ; /* points/inch */

/* set stylus fixed extends */
xMaxStylus=trunc((xdmi*xppi)/1000)
yMaxStylus=trunc((ydmi*yppi)/1000)

/* set stylus margins */
xMinStylus=trunc(xMaxStylus/10)
xMaxStylus=xMaxStylus-xMinStylus
yMinStylus=trunc(yMaxStylus/10)
yMaxStylus=yMaxStylus-yMinStylus

/* report stylus extends */
extends='xSize='||xdmm||' mm. xMinStylus='||xMinStylus||' points. xMaxStylus='||xMaxStylus||' points.'
rc=lineout(ddNameR,extends) ; say extends
extends='ySize='||ydmm||' mm. yMinStylus='||yMinStylus||' points. yMaxStylus='||yMaxStylus||' points.'
rc=lineout(ddNameR,extends) ; say extends

/* initialize mouse events */
But1Down=x2c(0600) ; But2Down=x2c(1800)
But3Down=x2c(6000) ; ButsDown=x2c(1E00)
MoveOnly=x2c(0100) ; NoButMov=x2c(0000)

/* set screen fixed extends */
xMaxScreen=1280 ; yMaxScreen=800

/* move cursor to center */
xMin=0 ; xMax=xMaxScreen ; xPos=trunc(xMax/2)
yMin=0 ; yMax=yMaxScreen ; yPos=trunc(yMax/2)
xMaxOut=reverse(d2c(xMaxScreen,2))
yMaxOut=reverse(d2c(yMaxScreen,2))
call xsMouse(MoveOnly)
LastEvent=MoveOnly

/* catch these here to release the mouse */
signal on error; signal on failure; signal on halt;
signal on novalue; signal on syntax;

/* initialize */
oiBuffer = x2c('EC 00 00 00 81 03 09 00 EE EE EE EE EE EE EE EE EE')

do forever
  call GetPacket
  event=substr(oiBuffer,9,2)
  select
    when event=x2c(0200) then call ReleaseButtons
    when event=x2c(0280) then call ReleaseButtons
    when event=x2c(02C0) then call ReleaseButtons
    when event=x2c(02D0) then call ReleaseButtons
    when event=x2c(02E0) then call ReleaseButtons
    when event=x2c(02E1) then call ReleaseButtons
    when event=x2c(02E3) then call ReleaseButtons
    when event=x2c(02E5) then call ReleaseButtons
    when event=x2c(02F0) then call Stylus(MoveOnly)
    when event=x2c(02F1) then call Stylus(But1Down)
    when event=x2c(02F2) then call Stylus(But2Down)
    when event=x2c(02F3) then call Stylus(But2Down)
    when event=x2c(02F4) then call Stylus(But3Down)
    when event=x2c(02F5) then call Stylus(But3Down)
    when event=x2c(02F8) then call Stylus(MoveOnly)
    when event=x2c(02F9) then call Stylus(But1Down)
    otherwise call Unknown
    end
  end

/* cleanup */
signal ProcessComplete
exit

GetPacket:
rc=charout(ddNameI,oiBuffer)
rc=stream(ddNameI,'description')
if rc \= 'READY:'
then do
  /* obtain error message */
  parse value rc with sState ':' mNumber
  if mNumber == 95 /* character i/o call interrupted */
  then rc=stream(ddNameI,'command','open') /* retry */
  else do
    /* issue error message */
    say SysGetMessage(mNumber,,ddNameI)
    say 'get stylus packet failed!'
    /* wait */
    '@pause'
    exit
    end
  end
return

ReleaseButtons:
/* release only once */
if LastEvent==NoButMov then return
call xsMouse(NoButMov)
LastEvent=NoButMov
return

Stylus:
parse arg type
/* stylus position */
xPos=c2d(substr(oiBuffer,11,1))+256*c2d(substr(oiBuffer,12,1))
yPos=c2d(substr(oiBuffer,13,1))+256*c2d(substr(oiBuffer,14,1))
/* stylus calibration */
if xPos<xMinStylus then xMinStylus=xPos
if xPos>xMaxStylus then xMaxStylus=xPos
if yPos<yMinStylus then yMinStylus=yPos
if yPos>yMaxStylus then yMaxStylus=yPos
/* use stylus extends */
xMin=xMinStylus ; xMax=xMaxStylus
yMin=yMinStylus ; yMax=yMaxStylus
/* use stylus pointer */
call xsMouse(type)
LastEvent=type
return

Unknown:
/* show packet */
packet=c2x(substr(oiBuffer,9))
output='Packet='||packet||',Huh?'
rc=lineout(ddNameR,output)
say output
return

xsMouse:
parse arg EvntFlgs
/* calculate current screen position */
xCur=trunc(((xPos-xMin)*xMaxScreen)/(xMax-xMin))
yCur=trunc(((yPos-yMin)*yMaxScreen)/(yMax-yMin))

/* prepare event buffer */
xPosOut=reverse(d2c(xCur,2))
yPosOut=reverse(d2c(yCur,2))
oBuffer = EvntFlgs||yPosOut||xPosOut||yMaxOut||xMaxOut

/* write this event */
rc=charout(ddNameO,oBuffer)
rc=stream(ddNameO,'description')
/* check completion code */
if rc \= 'READY:'
then do
  say
  /* obtain and issue error message */
  parse value rc with sState ':' mNumber
  say SysGetMessage(mNumber,,ddNameO)
  /* wait */
  '@pause'
  exit
  end
return

/* report signal information */
error: failure: halt: novalue: syntax:
parse source system invokation filename
info=condition('c')||' condition raised at line '||sigl||' of'||'0D0A'x
info=info||filename||'0D0A'x||'|'||sourceline(sigl)
rc=lineout(ddNameR,info) ; say info

ProcessComplete:
/* report stylus extends */
extends='xSize='||xdmm||' mm. xMinStylus='||xMinStylus||' points. xMaxStylus='||xMaxStylus||' points.'
rc=lineout(ddNameR,extends) ; say extends
extends='ySize='||ydmm||' mm. yMinStylus='||yMinStylus||' points. yMaxStylus='||yMaxStylus||' points.'
rc=lineout(ddNameR,extends) ; say extends

/* release the emulate mouse driver */
rc=stream(ddNameO,'command','close')
/* release the direct control driver */
rc=stream(ddNameI,'command','close')

/* report astylus.cmd stopped */
info='<============<astylus.cmd> stopped on <'||date()||'> at <'||time()'>============>'
rc=lineout(ddNameR,info) ; say info
exit
