
Spook and GAWK
--------------

Below is an example script to use 'spook' in cooperation with
GAWK, the GNU version of AWK.
See it as a start for implementing a library of GAWK functions to
get the same support we offer you for Perl.



#! /usr/local/bin/gawk -f

BEGIN {            
        spin  = sprintf(".spook.in.%d", systime());
        spout = sprintf(".spook.out.%d", systime());
        
        cmd = sprintf("mknod %s p", spin);
        system(cmd);
        close(cmd);
        cmd = sprintf("mknod %s p", spout);
        system(cmd);
        close(cmd);
        
        spook = sprintf("spook < %s > %s &", spin, spout);
        system(spook);

        print "= host dutepp0" > spin;
        system("");
        getline $result < spout;
        print $result;

        print "= community dnpap" > spin;
        system("");
        getline $result < spout;
        print $result;
}


END {                    
        close(spook);
        
        close(spin);
        cmd = sprintf("rm %s", spin);
        system(cmd);
        close(cmd);
        
        close(spout);
        cmd = sprintf("rm %s", spout);
        system(cmd);
        close(cmd);
}


