#include <memory.h>
#include <stdio.h>
#define  INCL_BASE
#include <os2.h>
#include <dnpap.h>
#include <message.h>
#include <timer.h>
#include <block.h>
#include <mac.h>
#include <snor.h>
#include <ether.h>
#include <ip.h>
#include <icmp.h>
#include <udp.h>
#include <pipe.h>
#include <maxmem.h>
#include <echo.h>
#include <mibsup.h>
#include <sys.h>
#include "agent.h"


MIB_COMMUNITY testPrf[] =
{                                
    { "public", 6, MIB_READ},
    { "dnpap", 5, MIB_READ | MIB_WRITE },
    { "collector", 9, MIB_READ | MIB_WRITE },
    { "viewer", 6, MIB_READ | MIB_WRITE }
};

MIB_ELEMENT testObj[] =
{
    { {1,3,6,1,2,1,1,1}, 8,  sysDescr, MIB_DISPLAYSTR, MIB_READ},
    { {1,3,6,1,2,1,1,2}, 8,  sysObjectID, MIB_OBJECTID, MIB_READ},
    { {1,3,6,1,2,1,1,3}, 8,  sysUpTime, MIB_TIMETICKS, MIB_READ},
    { {1,3,6,1,2,1,1,4}, 8,  sysContact, MIB_DISPLAYSTR, MIB_READ | MIB_WRITE},
    { {1,3,6,1,2,1,1,5}, 8,  sysName, MIB_DISPLAYSTR, MIB_READ | MIB_WRITE},
    { {1,3,6,1,2,1,1,6}, 8,  sysLocation, MIB_DISPLAYSTR, MIB_READ},
    { {1,3,6,1,2,1,1,7}, 8,  sysServices, MIB_INTEGER, MIB_READ},
};


static void Every5Seconds(TIMER_DESCR *timer, ULONG now, void *parm)
{
    printf("Available memory: %lu\n", MemoryGetAvail());
    AgentSendTrap("public", 6, MIB_WARMSTART, 0, 0, 0); 
}

void main(void)
{
    MAC_IFACE   *ifaceMac;
    IP_IFACE    ifaceIp;
    
                                             
    MemoryInit(8000000L, 32000L);
    
    MessageInit("stdio:out", MSGFILE, MSGSTDIO, NULL);
    MessageConfig(TEST_ERROR, "test");

    SysInit();
    
    MibInit(testPrf, testObj, 4, 7);
    
    if (!AgentInit())
    {
        DnpapMessage(DMC_ERROR,TEST_ERROR,"AgentInit");
        DnpapExit(1);
    }

    if (!TimerInit())
    {
        DnpapMessage(DMC_ERROR,TEST_ERROR,"TimerInit");
        DnpapExit(1);
    }

    if (!EchoInit())
    {
        DnpapMessage(DMC_ERROR,TEST_ERROR,"EchoInit");
        DnpapExit(1);
    }

    if (!UdpInit())
    {
        DnpapMessage(DMC_ERROR,TEST_ERROR,"UdpInit");
        DnpapExit(1);
    }

    if (!IcmpInit())
    {
        DnpapMessage(DMC_ERROR,TEST_ERROR,"IcmpInit");
        DnpapExit(1);
    }

    if (!IpInit())
    {
        DnpapMessage(DMC_ERROR,TEST_ERROR,"IpInit");
        DnpapExit(1);
    }
    
    if (!ArpInit())
    {
        DnpapMessage(DMC_ERROR,TEST_ERROR,"ArpInit");
        DnpapExit(1);
    }
    
    if (!EtherInit())
    {
        DnpapMessage(DMC_ERROR,TEST_ERROR,"EtherInit");
        DnpapExit(1);
    }
    

    if (!BlockInit())
    {
        DnpapMessage(DMC_ERROR,TEST_ERROR,"BlockInit");
        DnpapExit(1);
    }

    if (!PipeInit())
    {
        DnpapMessage(DMC_ERROR,TEST_ERROR,"PipeInit");
        DnpapExit(1);
    }

    if (!SnorInit())
    {
        DnpapMessage(DMC_ERROR,TEST_ERROR,"SnorInit");
        DnpapExit(1);
    }
    
    ifaceMac = MacIfaceFind("NEUS0$");
    if (ifaceMac==0)
    {
        DnpapMessage(DMC_ERROR,TEST_ERROR,"Iface NEUS0$ not found");
        DnpapExit(1);
    }
    
    printf("%02x:%02x:%02x:%02x:%02x:%02x\n",
        (WORD)ifaceMac->addr[0],
        (WORD)ifaceMac->addr[1],
        (WORD)ifaceMac->addr[2],
        (WORD)ifaceMac->addr[3],
        (WORD)ifaceMac->addr[4],
        (WORD)ifaceMac->addr[5]);

    ifaceIp.iface   = ifaceMac;
    ifaceIp.up      = TRUE;
    ifaceIp.addr    = 0x82a19104;
    ifaceIp.mask    = 0xffff0000;

    if (!IpIfaceRegister(&ifaceIp))
    {
        DnpapMessage(DMC_ERROR,TEST_ERROR,"IpIfaceRegister");
        DnpapExit(1);
    }

    if (!TimerRegister(Every5Seconds, 0, 5000L,
                TIMER_FOREVER, TIMER_TYPE_SKIP))
    {
        DnpapMessage(DMC_ERROR,TEST_ERROR,"Could not register timer");
        DnpapExit(1);
    }

    if (!Block())
    {
        DnpapMessage(DMC_ERROR,TEST_ERROR,"Block");
        DnpapExit(1);
    }

    SnorExit();


}


