/************************************************************************
** MODULE INFORMATION **
************************
** FILE NAME:          capturec.c
** SYSTEM NAME:        beholder
** MODULE NAME:        capture
** ORIGINAL AUTHOR(S): M.F.B. de Greeve
** VERSION NUMBER:     1.0
** CREATION DATE:      1992/9/7
** DESCRIPTION:        capture group of the RMON MIB
*************************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <dnpap.h>
#include <timer.h>
#include <mac.h>
#include <protocol.h>
#include <message.h>
#include <config.h>
#include <sys.h>
#include <maxmem.h>

#include "capturee.h"
#include "capturec.h"



BOOLEAN CaptureConfigInit(VOID)
{
SHORT p;

    if (ConfigGetShort("beholder.capture.memoryperc", &p))
        memoryPerc = p;
    if (memoryPerc > 100)
    {
        DnpapMessage(DMC_WARNING, CAPTURE_MEMPERC, "capture: CaptureMemoryPerc set to 75");
        memoryPerc = 75;
    }
    return TRUE;
}


/*****************************************************************
** NAME:        CaptureInit
** SYNOPSIS:    BOOLEAN CaptureInit (BUFFER *Buffer)
** PARAMETERS:  pointer to data Buffer entry
** DESCRIPTION: initializes collector.
** REMARKS:     called when status is CREATE_REQUEST: see capturem.c
** RETURNS:     TRUE: everything OK
*******************************************************************/

BOOLEAN CaptureInit (BUFFER *Buffer)
{
    Buffer->ChannelIndex = 1;                              /* first channel */
    Buffer->FullStatus = 1;                               /* spaceAvailable */
    Buffer->FullAction = 1;                                 /* lockWhenFull */
    Buffer->CaptureSliceSize = 100;
    Buffer->DownloadSliceSize = 100;
    Buffer->MaxOctetsRequested = -1;
    Buffer->MaxOctetsGranted = -1;
    Buffer->MaxOctetsAvailable = (memoryPerc * MemoryGetAvail()) / 100;
    
    if (Buffer->MaxOctetsAvailable > (LONG) MemoryGetMaxChunk())
        Buffer->MaxOctetsAvailable = (LONG) MemoryGetMaxChunk();

    if ((Buffer->Capture = DnpapMalloc (Buffer->MaxOctetsAvailable)) == NULL)
        return FALSE;

    Buffer->FirstPkt = (CAPTURE *) Buffer->Capture;
    Buffer->LastPkt = (CAPTURE *) Buffer->Capture;
    memset (Buffer->Capture, 0, (SHORT) Buffer->MaxOctetsAvailable);
    Buffer->MaxOctetsFree = Buffer->MaxOctetsAvailable;
    return TRUE;
}


/*****************************************************************
** NAME:        CaptureStart
** SYNOPSIS:    BOOLEAN CaptureStart (BUFFER *Buffer)
** PARAMETERS:  pointer to data Buffer entry
** DESCRIPTION: starts collector.
** REMARKS:     called when status is VALID: see capturem.c
** RETURNS:     TRUE: everything OK
*******************************************************************/

BOOLEAN CaptureStart (BUFFER *Buffer)
{
    Buffer->TurnOnTime = (LONG) SysTime();
    return(TRUE);
}


/*****************************************************************
** NAME:        CaptureStop 
** SYNOPSIS:    BOOLEAN CaptureStop (BUFFER *Buffer)
** PARAMETERS:  pointer to Buffer entry
** DESCRIPTION: stops collector.
** REMARKS:     called when status is INVALID: see capturem.c
** RETURNS:     TRUE
*******************************************************************/

BOOLEAN CaptureStop (BUFFER *Buffer)
{
    return(TRUE);
}

