#ifndef _CAPTUREC_H
#define _CAPTUREC_H


#include <dnpap.h>
#include <snmp.h>
#include <mibsup.h>


typedef struct _CAPTURE
{
    SHORT           Len;
    LONG            ID;
    LONG            Time;
} CAPTURE;


typedef struct _BUFFER
{
    LONG            ChannelIndex;
    LONG            FullStatus;
    LONG            FullAction;
    LONG            CaptureSliceSize;
    LONG            DownloadSliceSize;
    LONG            DownloadOffset;
    LONG            MaxOctetsRequested;
    LONG            MaxOctetsGranted;
    LONG            MaxOctetsAvailable;
    LONG            MaxOctetsFree;
    LONG            CapturedPkts;
    LONG            TurnOnTime;
    BYTE            *Capture;
    CAPTURE         *FirstPkt;
    CAPTURE         *LastPkt;
    LONG            LastPktID;
    BYTE            Owner[SNMP_SIZE_BUFCHR];
    WORD            OwnerLen;
    LONG            Status;

} BUFFER;


IMPORT WORD         memoryPerc;


BOOLEAN CaptureConfigInit(VOID);

BOOLEAN CaptureInit (BUFFER *buffer);
BOOLEAN CaptureStart (BUFFER *buffer);
BOOLEAN CaptureStop (BUFFER *buffer);


#endif
