#ifndef _EVENT_C_H
#define _EVENT_C_H


#include <dnpap.h>
#include <log.h>


#define RMONEVENT_SZEDESCR  128
#define RMONEVENT_SZECOMM   128


typedef struct RmonEvent_
{     
	CHAR Description[RMONEVENT_SZEDESCR];
    WORD DescrLen;
	LONG Type;
	BYTE Community[RMONEVENT_SZECOMM];
    WORD CommLen;
	ULONG LastTimeSent;
	BYTE Owner[SNMP_SIZE_BUFCHR];
	WORD OwnerLen;
	WORD Status;
	
    LONG NrLogs;
	LONG LogPos;
	LONG LogIndex;
	BOOLEAN LogBounced;
	RmonLog *Logs;
	
} RmonEvent;


BOOLEAN     EventCInit(RmonEvent* event);
BOOLEAN     EventCStart(RmonEvent* event);
BOOLEAN     EventCStop(RmonEvent* event);

RmonEvent*  NewRmonEvent(WORD nrevents);
RmonEvent*  ReNewRmonEvent(RmonEvent* ptr, WORD nrevents);
VOID        DelRmonEvent(RmonEvent* ptr);


#endif

