#include <dnpap.h>
#include <memory.h>
#include <mib.h>
#include <mibrqs.h>
#include <string.h>
#include <timer.h>

#include "neuro_d.h"
#include "neuro_e.h"
#include "neuro_k.h"
#include "neuro_c.h"



static CHAR MODULE[] =	"NeuroCollector";



typedef struct MIB_PROFIL_
{
    BYTE*   Comm;
    WORD    CommLen;
} MIB_PROFIL;


static BOOLEAN      NeuroCheckDataSource(NeuroData* data);

static FLOAT*       NewOutputValues(LONG nrouts);
static FLOAT*       ReNewOutputValues(FLOAT* values, LONG nrouts);
static VOID         DelOutputValues(FLOAT* values);



BOOLEAN NeuroCInit(NeuroData* data)
{			    
	strcpy(data->Owner.Name, MODULE);
	data->Owner.NameLen = strlen(MODULE);
	data->Status = MIB_INVALID;
	
	strcpy(data->Comm, "public");
	data->CommLen = strlen("public");
	
	data->NrLayers = 3;
	data->NrNeurons[0] = 2;
	data->NrNeurons[1] = 2;
	data->NrNeurons[2] = 1;
	data->NrNeurons[3] = 0;
	data->NrNeurons[4] = 0;

	data->NetRefresh = 10000;
		
	data->InputData = NULL;
	data->TargetData = NULL;
	data->OutputValue = NULL;
	
	data->Train = FALSE;
	
	data->LearningRate = 0.1;
	data->Momentum = 0.5;
	
	data->TotalSteps = 0;
	data->TrainSteps = 0;
	
	data->Error = 0;
	
	data->Timer = NULL;
	
	return TRUE;
}


BOOLEAN NeuroCStart(NeuroData* data, TIMER_CALLBACK callback, VOID* param, ULONG msecs)
{			
	if (NeuroCheckDataSource(data) == FALSE)
	{
		NeuroCStop(data);
		ERROR(MODULE, NEURO_DATASRC);
		return FALSE;
	}
	
	if ((data->Net = NewNeuronNet(0, data->NrLayers, 
				 data->NrNeurons[0], data->NrNeurons[1],
				 data->NrNeurons[2], data->NrNeurons[3],
				 data->NrNeurons[4])) == NULL)
	{
		NeuroCStop(data);
		ERROR(MODULE, NEURO_ALLOCATE);
		return FALSE;
	}	   
	
	if ((data->Timer = TimerRegister(callback, param, msecs,
				TIMER_FOREVER, TIMER_TYPE_SKIP)) == NULL)
	{
		NeuroCStop(data);
		ERROR(MODULE, NEURO_TIMERREG);
		return FALSE;
	}
}


BOOLEAN NeuroCStop(NeuroData* data)
{		    
	DelNeuronNet(data->Net);
	
	DelInOutData(data->InputData);
	DelInOutData(data->TargetData);
	DelOutputValues(data->OutputValue);
		    
	TimerRemove(data->Timer);
	
	return TRUE;
}


BOOLEAN NeuroCheckDataSource(NeuroData* data)
{			
MIB_PROFIL prf = { MODULE, sizeof(MODULE) };
MIB_OBJECT obj = { MIB_RQSGET, { 0, 0 }, 2, MIB_INTEGER, MIB_VALID };
LONG l, n;
InOutData* datasource;
	     	     
	for (l = 0; l == 0 || l == data->NrLayers-1; l += data->NrLayers-1)
	{
		for (n = 0; n < data->NrNeurons[l]; n++)
		{
			if (l == 0)
				datasource = &data->InputData[n];
			else	
			if (l == data->NrLayers-1)
				datasource = &data->TargetData[n];
			else
				datasource = NULL;
				
			if (datasource->IdLen == 0)
				return FALSE;
			else
			{
				memcpy(prf.Comm, data->Comm, 
					(prf.CommLen = data->CommLen)*sizeof(prf.Comm[0]));
				memcpy(obj.Id, datasource->Id, 
					(obj.IdLen = datasource->IdLen)*sizeof(obj.Id[0]));
				if (MibRequest(prf.Comm, prf.CommLen, &obj) == MIB_NOERROR)
				{		     
					switch (obj.Type)
					{
					case MIB_INTEGER:
					case MIB_COUNTER:
					case MIB_GAUGE:
					case MIB_TIMETICKS:
						break;
					default:	     
						ERROR(MODULE, NEURO_INVDATASRC);
						return FALSE;
					}
				}
				else
				{
					ERROR(MODULE, NEURO_NOSUCHDATASRC);
					return FALSE;
				}
			}
		}
	}
}

 
BOOLEAN NeuroCChangeTimer(NeuroData* data, ULONG msecs)
{
	if (TimerChange(data->Timer, msecs) == 0)
		return FALSE;
	return TRUE;
}


NeuroData* NewNeuroData(VOID)
{
	return (NeuroData*)MALLOC(sizeof(NeuroData));
}


VOID DelNeuroData(NeuroData* data)
{
	FREE(data);
}


InOutData* NewInOutData(LONG nrinouts)
{
InOutData* new;
LONG i;

	if ((new = MALLOC(nrinouts*sizeof(InOutData))) != NULL)
		for (i = 0; i < nrinouts; i++)
			InOutDataInit(&new[i]);
	return new;
}

		    
InOutData* ReNewInOutData(InOutData* data, LONG nrinouts, LONG prvnrinouts)
{
InOutData* new;
LONG i;

	if ((new = REALLOC(data, nrinouts*sizeof(InOutData))) != NULL)
		for (i = prvnrinouts; i < nrinouts; i++)
			InOutDataInit(&new[i]);
	return new;
}

				       
VOID InOutDataInit(InOutData* data)
{
WORD i;

	data->Id[0] = 0;
	data->IdLen = 0;
	data->TheValue = 0;
	data->MaxValue = 1000;
	data->MinValue = 0;
	data->AverageMethod = SIMPLE_DIFF;
	data->AverageSteps = 1;
	for (i = 0; i < MAXNRSTEPS; i++)
		data->Value[i] = 0;
	data->Trap = FALSE;
	strcpy(data->TrapComm, "public");
	data->TrapCommLen = strlen("public");
	data->ThresholdCheck = NO_THRESHOLD;
	for (i = 0; i < MAXNRTHRESHOLDVALUES; i++)
		data->ThresholdValue[i] = 0;
}


VOID DelInOutData(InOutData* data)
{
	FREE(data);
}


FLOAT* NewOutputValues(LONG nrouts)
{
	return MALLOC(nrouts*sizeof(FLOAT));
}


FLOAT* ReNewOutputValues(FLOAT* values, LONG nrouts)
{
	return REALLOC(values, nrouts*sizeof(FLOAT));
}


VOID DelOutputValues(FLOAT* values)
{
	FREE(values);
}

