#ifndef _DSTATC_H
#define _DSTATC_H


#include <dnpap.h>
#include <mac.h>
#include <timer.h>
#include <snmp.h>


typedef struct _DNPAP_ETHER_STATS
{
    LONG            Source[SNMP_SIZE_BUFINT];
    WORD            SourceLen;
    MAC_STAT        BaseStat;
    ULONG           Octets; 
    ULONG           Pkts; 
    ULONG           Pkts64Octets; 
    ULONG           Pkts65to127Octets; 
    ULONG           Pkts128to255Octets; 
    ULONG           Pkts256to511Octets;
    ULONG           Pkts512to1023Octets;
    ULONG           Pkts1024to1518Octets;
    BYTE            Owner[SNMP_SIZE_BUFCHR];
    WORD            OwnerLen;
    LONG            Status;

    MAC_IFACE       *Iface;
    MAC_COLL        Coll;

    /* DNPAP additions  */
    LONG            IATNrBuckets;
    LONG            IATInterval;
    ULONG           *IATBuckets;
    
    ULONG           IATTime;
    
} DNPAP_ETHER_STATS;


BOOLEAN DnpapStatCInit (DNPAP_ETHER_STATS *etherStats);
BOOLEAN DnpapStatCStart (DNPAP_ETHER_STATS *etherStats);
BOOLEAN DnpapStatCStop (DNPAP_ETHER_STATS *etherStats);

ULONG *NewBuckets(LONG nrbuckets);
ULONG *ReNewBuckets(ULONG *buckets, LONG nrbuckets);
VOID DelBuckets(ULONG *buckets);


#endif
