!include ..\..\include\standard.mak

SYS     = beholder
LIBS    = $(LIBDIR)\dnpap.lib $(LIBDIR)\b2.lib $(LIBDIR)\stack.lib $(LIBDIR)\collect.lib $(LIBDIR)\system.lib $(LIBDIR)\snmp.lib $(LIBDIR)\dnpapx.lib 

all: exe

install: all $(BINDIR)\$(SYS).exe

$(BINDIR)\$(SYS).exe: $(SYS).exe 
	$(CP) $(SYS).exe $(BINDIR)\$(SYS).exe
	$(CP) $(SYS).ico $(BINDIR)\$(SYS).ico

$(MANDIR)\$(SYS).man: $(SYS).man 
	$(CP) $(SYS).man $(MANDIR)\$(SYS).man 


doc: $(SYS).man

exe: $(SYS).exe

clean:
    - $(RM) *.exe
    - $(RM) *.obj
    - $(RM) *.i
    - $(RM) *.lib
    - $(RM) *.man
    - $(RM) *.err
    - $(RM) *.bak

$(SYS).man: $(SYS).c
    $(MAN) -R:API  $(SYS).c > $(SYS).man

$(SYS).obj: $(SYS).c $(SYS).h

$(SYS).ini: $(SYS).cfg

$(SYS).exe: $(SYS).obj $(LIBS)
    $(LINK) $(SYS).obj $(LIBS)
    markexe windowcompat $(SYS).exe
