#ifndef PROT_H
#define PROT_H

#include <dnpap.h>


BOOLEAN ProtBeholderPrint (PROT_OBJ *Obj, BYTE **StrPtr);
BOOLEAN ProtEthernetHeader (PROT_PKT *Pkt);
BOOLEAN ProtEthernetField (PROT_PKT *Pkt, PROT_OBJ *Obj);
BOOLEAN ProtEthernetPrint (PROT_OBJ *Obj, BYTE **StrPtr);
BOOLEAN ProtIPHeader (PROT_PKT *Pkt);
BOOLEAN ProtIPField (PROT_PKT *Pkt, PROT_OBJ *Obj);
BOOLEAN ProtIPPrint (PROT_OBJ *Obj, BYTE **StrPtr);
BOOLEAN ProtTCPHeader (PROT_PKT *Pkt);
BOOLEAN ProtTCPField (PROT_PKT *Pkt, PROT_OBJ *Obj);
BOOLEAN ProtTCPPrint (PROT_OBJ *Obj, BYTE **StrPtr);
BOOLEAN ProtUDPHeader (PROT_PKT *Pkt);
BOOLEAN ProtUDPField (PROT_PKT *Pkt, PROT_OBJ *Obj);
BOOLEAN ProtUDPPrint (PROT_OBJ *Obj, BYTE **StrPtr);
BOOLEAN ProtICMPHeader (PROT_PKT *Pkt);
BOOLEAN ProtICMPField (PROT_PKT *Pkt, PROT_OBJ *Obj);
BOOLEAN ProtICMPPrint (PROT_OBJ *Obj, BYTE **StrPtr);
BOOLEAN ProtARPHeader (PROT_PKT *Pkt);
BOOLEAN ProtARPField (PROT_PKT *Pkt, PROT_OBJ *Obj);
BOOLEAN ProtARPPrint (PROT_OBJ *Obj, BYTE **StrPtr);
BOOLEAN ProtDNSHeader (PROT_PKT *Pkt);
BOOLEAN ProtDNSField (PROT_PKT *Pkt, PROT_OBJ *Obj);
BOOLEAN ProtDNSPrint (PROT_OBJ *Obj, BYTE **StrPtr);

extern BYTE *protocolString;
extern BYTE *protBeholderString[];
extern BYTE *protEthernetString[];
extern BYTE *protIPString[];
extern BYTE *protTCPString[];
extern BYTE *protUDPString[];
extern BYTE *protICMPString[];
extern BYTE *protARPString[];
extern BYTE *protDNSString[];

static PROT_PTR ProtPtr[] =
{
    {"UNKNOWN"},
    {"BEHOLDER", NULL, NULL, ProtBeholderPrint, protBeholderString, 6},
    {"ETHERNET", ProtEthernetHeader, ProtEthernetField, ProtEthernetPrint, protEthernetString, 3},
    {"IP", ProtIPHeader, ProtIPField, ProtIPPrint, protIPString, 13},
    {"TCP", ProtTCPHeader, ProtTCPField, ProtTCPPrint, protTCPString, 11},
    {"UDP", ProtUDPHeader, ProtUDPField, ProtUDPPrint, protUDPString, 4},
    {"ICMP", ProtICMPHeader, ProtICMPField, ProtICMPPrint, protICMPString, 3},
    {"ARP", ProtARPHeader, ProtARPField, ProtARPPrint, protARPString, 9},
    {"RARP", ProtARPHeader, ProtARPField, ProtARPPrint, protARPString, 9},
    {"DNS", ProtDNSHeader, ProtDNSField, ProtDNSPrint, protDNSString, 10}
};

#endif
