#ifndef _CHAIN_H_
#define _CHAIN_H_


#include <dnpap.h>


#define CHAIN_FLAG_DNPAP_CHAIN   0x01
#define CHAIN_FLAG_DNPAP_BUFFER  0x02


typedef struct _CHAIN  CHAIN;

struct _CHAIN
{
    BYTE            *buffer;
    WORD            offset;
    WORD            length;
    WORD            size;
    BYTE            flags;
    CHAIN           *next;
};




BYTE    *ChainPush(CHAIN **chain, WORD size);
BYTE    *ChainPop(CHAIN **chain, WORD size);


CHAIN   *ChainAlloc(CHAIN *chain, BYTE *buffer, WORD size, WORD length, WORD offset, CHAIN *next);
BOOLEAN ChainCopy(CHAIN *chain, BYTE *buffer, WORD size);
void    ChainFree(CHAIN *chain);


WORD    ChainAvailSpace(CHAIN *chain);
WORD    ChainAvailData(CHAIN *chain);

WORD    ChainLength(CHAIN *chain);
WORD    ChainSize(CHAIN *chain);

BOOLEAN ChainSplit(CHAIN *head, CHAIN *tail, WORD length);


#endif
