#include <memory.h>
#include <stdio.h>
#define  INCL_BASE
#include <os2.h>
#include <dnpap.h>
#include <message.h>
#include <timer.h>
#include <block.h>
#include <mac.h>
#include <snor.h>
#include <ether.h>
#include <ip.h>
#include <icmp.h>
#include <udp.h>
#include <maxmem.h>
#include "echo.h"



static void ShowMem(TIMER_DESCR *timer, ULONG now, void *parm)
{
    printf("Available memory: %lu\n", MemoryGetAvail());
}

void main(void)
{
    MAC_IFACE   *ifaceMac;
    IP_IFACE    ifaceIp;
    
                                             
    MemoryInit(8000000L, 32000L);
    
    MessageInit("stdio:out", MSGFILE, MSGSTDIO, NULL);
    MessageConfig(TEST_ERROR, "test");

    if (!TimerInit())
    {
        DnpapMessage(DMC_ERROR,TEST_ERROR,"TimerInit");
        DnpapExit(1);
    }

    if (!EchoInit())
    {
        DnpapMessage(DMC_ERROR,TEST_ERROR,"EchoInit");
        DnpapExit(1);
    }

    if (!UdpInit())
    {
        DnpapMessage(DMC_ERROR,TEST_ERROR,"UdpInit");
        DnpapExit(1);
    }

    if (!IcmpInit())
    {
        DnpapMessage(DMC_ERROR,TEST_ERROR,"IcmpInit");
        DnpapExit(1);
    }

    if (!IpInit())
    {
        DnpapMessage(DMC_ERROR,TEST_ERROR,"IpInit");
        DnpapExit(1);
    }
    
    if (!ArpInit())
    {
        DnpapMessage(DMC_ERROR,TEST_ERROR,"ArpInit");
        DnpapExit(1);
    }
    
    if (!EtherInit())
    {
        DnpapMessage(DMC_ERROR,TEST_ERROR,"EtherInit");
        DnpapExit(1);
    }
    

    if (!BlockInit())
    {
        DnpapMessage(DMC_ERROR,TEST_ERROR,"BlockInit");
        DnpapExit(1);
    }

    if (!SnorInit())
    {
        DnpapMessage(DMC_ERROR,TEST_ERROR,"SnorInit");
        DnpapExit(1);
    }
    
    ifaceMac = MacIfaceFind("NEUS0$");
    if (ifaceMac==0)
    {
        DnpapMessage(DMC_ERROR,TEST_ERROR,"Iface NEUS0$ not found");
        DnpapExit(1);
    }
    
    printf("%02x:%02x:%02x:%02x:%02x:%02x\n",
        (WORD)ifaceMac->addr[0],
        (WORD)ifaceMac->addr[1],
        (WORD)ifaceMac->addr[2],
        (WORD)ifaceMac->addr[3],
        (WORD)ifaceMac->addr[4],
        (WORD)ifaceMac->addr[5]);

    ifaceIp.iface   = ifaceMac;
    ifaceIp.up      = TRUE;
    ifaceIp.addr    = 0x82a19104;
    ifaceIp.mask    = 0xffff0000;

    if (!IpIfaceRegister(&ifaceIp))
    {
        DnpapMessage(DMC_ERROR,TEST_ERROR,"IpIfaceRegister");
        DnpapExit(1);
    }

    if (!TimerRegister(ShowMem, 0, 5000L,
                TIMER_FOREVER, TIMER_TYPE_SKIP))
    {
        DnpapMessage(DMC_ERROR,TEST_ERROR,"Could not register timer");
        DnpapExit(1);
    }

    if (!Block())
    {
        DnpapMessage(DMC_ERROR,TEST_ERROR,"Block");
        DnpapExit(1);
    }

    SnorExit();


}


