#include <stdio.h>
#include <ip.h>
#include "icmp.h"


typedef struct _HDR  HDR;

struct _HDR
{
    BYTE        type;
    BYTE        code;
    WORD        check;
};



static BOOLEAN  Rcve(CHAIN *chain, IP_HDR *ipHdr);
static CHAIN    *HdrDecode(CHAIN *chain, ICMP_HDR *icmpHdr);
static CHAIN    *HdrEncode(CHAIN *chain, ICMP_HDR *icmpHdr);

IP_PROT icmpIp =
{
    Rcve,
    IP_PROT_ICMP
};





BOOLEAN IcmpInit(void)
{
    static BOOLEAN init = FALSE;
    
    if (!init)
    {
        init = IpProtRegister(&icmpIp);
    }

    return init;
}





static BOOLEAN Rcve(CHAIN *chain, IP_HDR *ipHdr)
{
    CHAIN       *new, *send;
    DWORD       addr;
    ICMP_HDR    icmpHdr;
    
    new = HdrDecode(chain, &icmpHdr);
    if (new != 0)
    {
        switch(icmpHdr.type)
        {
            case ICMP_ECHO_REQUEST:
                icmpHdr.type = ICMP_ECHO_REPLY;
                send = HdrEncode(new, &icmpHdr);
                if (send != 0)
                {
                    addr        = ipHdr->src;
                    ipHdr->src  = ipHdr->dst;
                    ipHdr->dst  = addr;
                    IpSend(send, ipHdr); 
                }
                if (send != new)
                    ChainFree(send);
        }
        if (new != chain)
            ChainFree(new);
    }
    return TRUE;
}


static CHAIN *HdrDecode(CHAIN *chain, ICMP_HDR *icmpHdr)
{
    HDR *h;
    

    if (IpHdrCheck(chain, ChainLength(chain)) != 0)
        return 0;
    
    h = (HDR *)ChainPop(&chain, sizeof(HDR));
    if (h==0)
        return 0;
    
    icmpHdr->type  = h->type;
    icmpHdr->code  = h->code;
    icmpHdr->check = IpN2HWord(h->check);

    return chain;
}


static CHAIN *HdrEncode(CHAIN *chain, ICMP_HDR *icmpHdr)
{
    HDR *h;
    
    h = (HDR *)ChainPush(&chain, sizeof(HDR));
    if (h==0)
        return 0;

    h->type     = icmpHdr->type;  
    h->code     = icmpHdr->code;  
    h->check    = 0;

    h->check    = IpHdrCheck(chain, ChainLength(chain));
    
    return chain;
}

