#include "snordef.h"
#include "snorerr.h"
#include "snorhdl.h"




int	SnorHdlMalloc(SNOR_DESCR *snor)
{
	int	i;

	if ( snor->handleCount >= SNOR_MAX_HANDLE )
	{
		return(-1);
	}
	else
	{
		snor->handleCount++;
		for ( i=0 ; i<SNOR_MAX_HANDLE ; i++ )
		{
		    if ( snor->handle[i].usMem2 == 0 )
			{
				snor->handle[i].usMem2 = 1;
				return(i);
			}
  		}
  	}
}


SNOR_MH	*SnorHdl2Ptr(SNOR_DESCR *snor, int handle)
{
	if ( handle>=0 && handle<SNOR_MAX_HANDLE )
		return(snor->handle+handle);
	else
  	{
		SnorErrPrint("Illegal handle");
        return(NULL);
  	}
}

VOID SnorHdlFree(SNOR_DESCR *snor, int handle)
{
	if ( handle>=0 && handle<SNOR_MAX_HANDLE )
	{
		if ( snor->handle[handle].usMem2 == 0 )
			SnorErrPrint("Free of illegal handle");
		else
		{
			snor->handle[handle].usMem2 = 0;
			snor->handleCount--;
		}
   	}
}























