#include <stdlib.h>
#include <stdio.h>
#include <memory.h>
#include <string.h>
#include <dnpap.h>
#include "config.h"



int main(int argc, char **argv)
{
LONG longbuf[] = { 1, 3, 6, 1, 2, 1};

    if (!ConfigInit(argc,argv))
    {
        DnpapMessage(DMC_FATAL, TEST_ERROR, "ConfigInit() failed");
        DnpapExit(1);
    }
    if (!ConfigLoad())
    {
        DnpapMessage(DMC_FATAL, TEST_ERROR, "ConfigLoad() failed");
        DnpapExit(1);
    }
    ConfigSetShort("newer.short", 9);
    ConfigSetLong("newer.long", 8);
    ConfigSetDouble("new.double", 3.14);
    ConfigSetString("new.string", "test");
    ConfigSetBytes("newer.binary", "\x01\x02\x03\x04\x05\x07\x08\x09\x0a", 10);
    ConfigSetLongBuf("newer.binary.long", longbuf, sizeof(longbuf)/sizeof(LONG));
    if (!ConfigSave())
    {
        DnpapMessage(DMC_FATAL, TEST_ERROR, "ConfigSave() failed");
        DnpapExit(1);
    }

    return 0;
}

