#ifndef TIMER_H
#define TIMER_H

#include <dnpap.h>

#define TIMER_FOREVER           0xFFFFFFFFL

#define TIMER_TYPE_RECOVER      0
#define TIMER_TYPE_SKIP         1

#define TIMER_EVENT_ERROR       0x01
#define TIMER_EVENT_EXPIRE      0x02


typedef struct _TIMER_DESCR     TIMER_DESCR;
typedef void                    (*TIMER_CALLBACK)(TIMER_DESCR *timer, ULONG now, void *parm);
typedef unsigned short          TIMER_EVENT;      

struct _TIMER_DESCR
{
    TIMER_CALLBACK callback;
    void           *parm;
    ULONG          msecs;
    ULONG          alarm;
    ULONG          count;
    int            type;
    TIMER_DESCR    *next;
};

BOOLEAN         TimerInit(void);
TIMER_DESCR     *TimerRegister(TIMER_CALLBACK callback, void *parm, ULONG msecs, 
                                ULONG count, int type);
ULONG           TimerRemove(TIMER_DESCR *timer);
BOOLEAN         TimerChange(TIMER_DESCR *timer, ULONG msecs);
LONG            TimerRemaining(void);
BOOLEAN         TimerCheck(void);
ULONG           TimerNow(void);

#endif







