
Spook and Python
----------------

Below is an example script to use 'spook' in cooperation with
Python, an object-oriented interpreted script language.
See it as a start for implementing a library of Python functions to
get the same support we offer you for Perl.



#! /usr/local/bin/python

import builtin
import posix

pid = posix.getpid()

spinname  = '.spook.in.' + `pid`
spoutname = '.spook.out.' + `pid`

result = posix.system('mknod ' + spinname + ' p')
result = posix.system('mknod ' + spoutname + ' p')

result = posix.system('spook < ' + spinname + ' > ' + spoutname + ' &')

spin  = open(spinname, 'w')
spout = open(spoutname, 'r')

result = spin.write('= host dutepp0\n')
result = spin.flush()
result = spout.readline()

print result

result = spin.write('= community dnpap\n')
result = spin.flush()
result = spout.readline()

print result

posix.unlink(spoutname)
posix.unlink(spinname)
