#ifdef GCC
#ifdef OS2
#define OS220
#endif
#endif

#define INCL_DOSERRORS      /* Include dos error codes (ERROR_PIPE_BUSY) */
#define INCL_DOSNMPIPES     /* Include prototypes of NP functions */
#include    <os2.h>
#include    <stdio.h>
#include    <dnpap.h>
#include    "mgmt.h"
#include    "pipe.h"


#ifdef OS220
#define DosTransactNmPipe DosTransactNPipe
#define DosWaitNmPipe DosWaitNPipe
#endif

BOOLEAN PipeOpen(MGMT *mgmt, char *agent)
{
    USHORT  uRet;
    USHORT  usAction;
    BYTE    name[255];
    

    sprintf(name,"\\pipe\\%s\\161",agent);
    uRet = DosOpen(
        name,
        &(mgmt->medium.pipe.handle),          /* address of file handle */
        &usAction,                      /* action taken           */
        100L,                           /* size of new file       */
        FILE_NORMAL,                    /* file attribute         */
        FILE_OPEN,                      /* create the file        */
        OPEN_ACCESS_READWRITE | OPEN_SHARE_DENYNONE, /* open mode */
        0L);                            /* reserved          */

    if (uRet==ERROR_PIPE_BUSY) /*AK*/
    {   /* When no pipe was found, or it was busy, wait for it */
        uRet=DosWaitNmPipe(name,100L);  /* Wait at max 100 milliseconds */
        if (uRet==0)                    /* Try again */
            uRet = DosOpen(
                name,
                &(mgmt->medium.pipe.handle),          /* address of file handle */
                &usAction,                      /* action taken           */
                100L,                           /* size of new file       */
                FILE_NORMAL,                    /* file attribute         */
                FILE_OPEN,                      /* create the file        */
                OPEN_ACCESS_READWRITE | OPEN_SHARE_DENYNONE, /* open mode */
                0L);                            /* reserved          */
    }
    if(uRet != 0)
    {
	    DnpapMessage(DMC_WARNING, MGMT_ERROR+1, "Error opening MGMT Pipe <%u>",
            uRet);
    }
    return (uRet == 0);
}

BOOLEAN PipeClose(MGMT *mgmt)
{
    int uRet;

    uRet = DosClose(mgmt->medium.pipe.handle);
    return (uRet == 0);
}


BOOLEAN PipeSend(MGMT *mgmt, BYTE *buffer, WORD length)
{
    int uRet, uWrite;
    
    uRet = DosWrite(
            mgmt->medium.pipe.handle,
            buffer,
            length,
            &uWrite);

    if (uRet==0)
    {
        return TRUE;
    }
    else
    {
        return FALSE;
    }
}




BOOLEAN PipeRecv(MGMT *mgmt, BYTE **buffer, WORD *length, ULONG timeout)
{
    BYTE data[1514];
    int uRet,uRead;
    
    uRet = DosRead(
            mgmt->medium.pipe.handle,
            data,
            sizeof(data),
            &uRead);
    if (uRet==0)
    {
        *buffer = data;
        *length = uRead;
        return TRUE;
    }
    else
    {
        return FALSE;
    }
}
