!include ..\include\standard.mak

SYS     = mibdf
SYSLIB  = mibdf

all: obj doc

install: all $(INCDIR)\$(SYS).h $(MANDIR)\$(SYS).man $(LIBDIR)\$(SYSLIB).lib

$(INCDIR)\$(SYS).h: $(SYS).h 
	$(CP) $(SYS).h $(INCDIR)\$(SYS).h

$(MANDIR)\$(SYS).man: $(SYS).man 
	$(CP) $(SYS).man $(MANDIR)\$(SYS).man 

$(LIBDIR)\$(SYSLIB).lib: $(SYS).obj mibapi.obj parse.obj
	$(AR) $(LIBDIR)\$(SYSLIB).lib -+$(SYS).obj -+mibapi.obj -+parse.obj;

obj: $(SYS).obj mibapi.obj parse.obj

doc: $(SYS).man

clean:
    - $(RM) *.exe
    - $(RM) *.obj
    - $(RM) *.i
    - $(RM) *.lib
    - $(RM) *.man
    - $(RM) *.err
    - $(RM) *.bak

$(SYS).man: $(SYS).c mibapi.c parse.c
    $(MAN) -R:API  $(SYS).c mibapi.c parse.c > $(SYS).man

test.exe: test.obj 
	$(LINK) test.obj ..\lib\dnpap.lib ..\lib\mgmt.lib ..\lib\mibdf.lib
	markexe windowcompat test.exe
